using System.Collections;
using System.Collections.Generic;
using Godot;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
	public partial class FrameSmoothing: Smoothing
	{
    [Export( PropertyHint.Range, "0,1800")]
    public float frames = 10;      
    
    protected override float _ComputeInterpolationAmount( float delta )
    {
      frames = Mathf.Clamp( frames, 0, 1800 );

      if ( frames <= 0 )
      {
        return 1;
      }      

      var coefficient = GetLerpedCoefficientForFrames( frames );
      return 1f - Mathf.Exp( -coefficient * delta );
    }

    public static float ComputeCoefficient( float delta, float frames )
    {
      int floored = Mathf.FloorToInt( frames );

      float low  = ComputeCoefficientInt( delta, floored );
      float high = ComputeCoefficientInt( delta, floored + 1 );

      return Mathf.Lerp( low, high, frames - floored );
    }

    public static float ComputeCoefficientInt( float delta, int frames )
    {
      frames = Mathf.Clamp( frames, 0, 1800 );

      if ( frames <= 0 )
      {
        return 1;
      }      

      var coefficient = GetCoefficientForFrames( frames );
      return 1f - Mathf.Exp( -coefficient * delta );
    }

    public static float GetLerpedCoefficientForFrames( float frames )
    {
      int floored = Mathf.FloorToInt( frames );

      float low  = GetCoefficientForFrames( floored );
      float high = GetCoefficientForFrames( floored + 1 );

      return Mathf.Lerp( low, high, frames - floored ); 
    }

    public static float GetCoefficientForFrames( int frames )
    {
      return FrameSmoothingTable.Get( frames );
    }

  }
}