using System.Collections;
using System.Collections.Generic;
using Godot;
using System.Threading.Tasks;

namespace Rokojori
{
	public class FrameSmoothingTable
	{ 
    public const int num = 60 * 60;

    public static float Get( int key )
    {
      key = Mathf.Clamp( key, 0, data.Length - 1 );
      return data[ key ];
    }

    public static void ComputeAndSaveTable( string path )
    {
      var computed = new float[ FrameSmoothingTable.num ];

      for ( int i = 0; i < num; i++ )
      {
        computed[ i ] = ExpSmoothing.ComputeCoefficientForFramesAdaptiveTreshold( i );
      }

      FilesSync.SaveUTF8( path, Lists.Join( Lists.From( computed ), "f,\n" ) );
    }

    public async static Task ComputeAndSaveTable( Node node, string path, int range = 0 )
    {
      range = range <= 0 ? num : range;
      // var computed = new float[ FrameSmoothingTable.num ];

      var time = Async.StartTimer();

      var lastReportInt = 0;

      var directoryPath = FilePath.Absolute( path );

      FilesSync.EnsureDirectoryExists( path );

      for ( int j = 0; j < num; j+=range )
      {

        var computed = new float[ range ];

        var filePath = directoryPath.MakeRelative( j + "-" + ( j + range ) + ".txt" );

        if ( FilesSync.FileExists( filePath.fullPath ) )
        { 
          node.LogInfo( "Skipping: ", j + "-" + ( j + range ) );
          continue;
        }

        node.LogInfo( "Processing: ", j + "-" + ( j + range ) );

        bool testing = true;

        if ( testing )
        {
          // continue;
        }

        for ( int i = 0; i < range; i++ )
        {
          computed[ i ] = ExpSmoothing.ComputeCoefficientForFramesAdaptiveTreshold( i + j );

          time = await Async.WaitIfExceeded( time, node );

          var currentInt = Mathf.RoundToInt( i * 100f / num );

          if ( lastReportInt != currentInt )
          {
            lastReportInt = currentInt;
            node.LogInfo( Mathf.Round( i * 100f / num ) + "%", i + "/" + num );
          }
          
        }

        FilesSync.SaveUTF8( filePath.fullPath, Lists.Join( Lists.From( computed ), "f,\n" ) );
      }

      

      // FilesSync.SaveUTF8( path, Lists.Join( Lists.From( computed ), "f,\n" ) );
    }

    static readonly float[] data = new float[]
    {
      500f,
      283.581298828125f,
      139.73373413085938f,
      92.77377319335938f,
      69.44607543945312f,
      55.49477767944336f,
      46.21171569824219f,
      39.58964157104492f,
      34.627803802490234f,
      30.771270751953125f,
      27.687593460083008f,
      25.16560173034668f,
      23.06490135192871f,
      21.287748336791992f,
      19.7650146484375f,
      18.445554733276367f,
      17.291311264038086f,
      16.27288246154785f,
      15.367767333984375f,
      14.558114051818848f,
      13.829330444335938f,
      13.170221328735352f,
      12.57108211517334f,
      12.024028778076172f,
      11.522516250610352f,
      11.061280250549316f,
      10.63553524017334f,
      10.241303443908691f,
      9.87530517578125f,
      9.534504890441895f,
      9.216452598571777f,
      8.918947219848633f,
      8.640054702758789f,
      8.378063201904297f,
      8.131572723388672f,
      7.899065971374512f,
      7.679544448852539f,
      7.471868515014648f,
      7.275096893310547f,
      7.088548183441162f,
      6.911216735839844f,
      6.7425761222839355f,
      6.58193302154541f,
      6.428795337677002f,
      6.282650947570801f,
      6.1429643630981445f,
      6.009374618530273f,
      5.881429195404053f,
      5.758898735046387f,
      5.641271591186523f,
      5.528425216674805f,
      5.41996431350708f,
      5.3156914710998535f,
      5.215364456176758f,
      5.118772029876709f,
      5.0256500244140625f,
      4.935863971710205f,
      4.849242210388184f,
      4.765618801116943f,
      4.684786319732666f,
      4.6067047119140625f,
      4.5311479568481445f,
      4.458031177520752f,
      4.387297630310059f,
      4.3186798095703125f,
      4.252230644226074f,
      4.18775749206543f,
      4.1252570152282715f,
      4.064601898193359f,
      4.005623817443848f,
      3.948420763015747f,
      3.8927950859069824f,
      3.8386731147766113f,
      3.7860772609710693f,
      3.7349131107330322f,
      3.6851160526275635f,
      3.636634349822998f,
      3.589371681213379f,
      3.5433261394500732f,
      3.4984500408172607f,
      3.4547362327575684f,
      3.41206955909729f,
      3.3704464435577393f,
      3.329827070236206f,
      3.2901761531829834f,
      3.251462697982788f,
      3.213653802871704f,
      3.176679849624634f,
      3.1405816078186035f,
      3.105264902114868f,
      3.070765256881714f,
      3.0370264053344727f,
      3.003992795944214f,
      2.9717040061950684f,
      2.940070390701294f,
      2.9091360569000244f,
      2.8788161277770996f,
      2.8491201400756836f,
      2.820035696029663f,
      2.791569709777832f,
      2.763646364212036f,
      2.7362406253814697f,
      2.709437608718872f,
      2.6831271648406982f,
      2.6572930812835693f,
      2.6320114135742188f,
      2.6071770191192627f,
      2.582808494567871f,
      2.5588653087615967f,
      2.5353894233703613f,
      2.512341022491455f,
      2.489710807800293f,
      2.4674808979034424f,
      2.445652723312378f,
      2.4241487979888916f,
      2.403071403503418f,
      2.382392168045044f,
      2.3620100021362305f,
      2.3419981002807617f,
      2.3223023414611816f,
      2.3029582500457764f,
      2.2839038372039795f,
      2.265169858932495f,
      2.2467894554138184f,
      2.228628396987915f,
      2.210813045501709f,
      2.1932532787323f,
      2.1759724617004395f,
      2.1590123176574707f,
      2.142235279083252f,
      2.125772714614868f,
      2.109534740447998f,
      2.0935709476470947f,
      2.077817678451538f,
      2.0623042583465576f,
      2.047018051147461f,
      2.0319600105285645f,
      2.0171475410461426f,
      2.00252366065979f,
      1.9881082773208618f,
      1.9739007949829102f,
      1.9598971605300903f,
      1.9460855722427368f,
      1.932471752166748f,
      1.9190549850463867f,
      1.905813455581665f,
      1.8927764892578125f,
      1.8798773288726807f,
      1.8671958446502686f,
      1.8546583652496338f,
      1.8422939777374268f,
      1.8300729990005493f,
      1.8180501461029053f,
      1.8061472177505493f,
      1.794433355331421f,
      1.7828596830368042f,
      1.771410346031189f,
      1.7601466178894043f,
      1.7490057945251465f,
      1.7379857301712036f,
      1.7271277904510498f,
      1.7163945436477661f,
      1.7058008909225464f,
      1.6953409910202026f,
      1.685006022453308f,
      1.6747899055480957f,
      1.6646863222122192f,
      1.6547212600708008f,
      1.6448748111724854f,
      1.63514244556427f,
      1.6255245208740234f,
      1.6160211563110352f,
      1.606610894203186f,
      1.5973433256149292f,
      1.5881503820419312f,
      1.5790756940841675f,
      1.570091724395752f,
      1.5612257719039917f,
      1.5524506568908691f,
      1.5437687635421753f,
      1.5351957082748413f,
      1.5267354249954224f,
      1.5183507204055786f,
      1.510025143623352f,
      1.5018233060836792f,
      1.493721842765808f,
      1.4856828451156616f,
      1.4777395725250244f,
      1.4698690176010132f,
      1.462095022201538f,
      1.4544039964675903f,
      1.4467787742614746f,
      1.4392509460449219f,
      1.431795358657837f,
      1.4244188070297241f,
      1.4171051979064941f,
      1.409865140914917f,
      1.4027140140533447f,
      1.3956362009048462f,
      1.388612985610962f,
      1.3816556930541992f,
      1.3748058080673218f,
      1.3679734468460083f,
      1.3612393140792847f,
      1.3545730113983154f,
      1.3479712009429932f,
      1.3414026498794556f,
      1.334961175918579f,
      1.3285306692123413f,
      1.3221654891967773f,
      1.3158795833587646f,
      1.3096164464950562f,
      1.303462028503418f,
      1.297347068786621f,
      1.291259765625f,
      1.2852731943130493f,
      1.2793049812316895f,
      1.2734116315841675f,
      1.2675613164901733f,
      1.2617697715759277f,
      1.2560545206069946f,
      1.2503502368927002f,
      1.2447389364242554f,
      1.2391352653503418f,
      1.233640432357788f,
      1.228132724761963f,
      1.2227063179016113f,
      1.2173126935958862f,
      1.2119815349578857f,
      1.2066696882247925f,
      1.2014259099960327f,
      1.1962333917617798f,
      1.19107186794281f,
      1.1859670877456665f,
      1.1808918714523315f,
      1.1758713722229004f,
      1.1708842515945435f,
      1.165951132774353f,
      1.1610461473464966f,
      1.1561956405639648f,
      1.1513667106628418f,
      1.14658522605896f,
      1.1418571472167969f,
      1.1371469497680664f,
      1.132511854171753f,
      1.1278595924377441f,
      1.1233044862747192f,
      1.1187365055084229f,
      1.114235520362854f,
      1.1097650527954102f,
      1.1053249835968018f,
      1.1008992195129395f,
      1.096550464630127f,
      1.0922147035598755f,
      1.0879191160202026f,
      1.0836459398269653f,
      1.0793945789337158f,
      1.075201392173767f,
      1.0710294246673584f,
      1.0668925046920776f,
      1.0627957582473755f,
      1.0587204694747925f,
      1.0546735525131226f,
      1.0506591796875f,
      1.0466867685317993f,
      1.042757511138916f,
      1.0388169288635254f,
      1.0349215269088745f,
      1.0310591459274292f,
      1.0272457599639893f,
      1.0234252214431763f,
      1.019643783569336f,
      1.015916347503662f,
      1.0121873617172241f,
      1.0084819793701172f,
      1.0048153400421143f,
      1.0011717081069946f,
      0.9975594282150269f,
      0.9939855337142944f,
      0.9903967976570129f,
      0.9868771433830261f,
      0.9833724498748779f,
      0.9798818826675415f,
      0.9764040112495422f,
      0.9729690551757812f,
      0.9695543050765991f,
      0.9661747813224792f,
      0.9627928733825684f,
      0.9594693183898926f,
      0.9561452269554138f,
      0.9528394341468811f,
      0.9495774507522583f,
      0.946311354637146f,
      0.9431012272834778f,
      0.9398893117904663f,
      0.9366958737373352f,
      0.933527946472168f,
      0.9303995370864868f,
      0.9272783994674683f,
      0.9241516590118408f,
      0.9210768342018127f,
      0.9180124998092651f,
      0.9149739146232605f,
      0.9119710922241211f,
      0.9089577198028564f,
      0.9059733748435974f,
      0.903017520904541f,
      0.9000647664070129f,
      0.8971512317657471f,
      0.8942551016807556f,
      0.8913599848747253f,
      0.8884860873222351f,
      0.8856471180915833f,
      0.8828186392784119f,
      0.880012035369873f,
      0.8772291541099548f,
      0.8744516372680664f,
      0.8716967701911926f,
      0.8689366579055786f,
      0.8662132620811462f,
      0.8635026216506958f,
      0.860801100730896f,
      0.858134925365448f,
      0.8554983735084534f,
      0.8528401255607605f,
      0.8502227663993835f,
      0.8476150035858154f,
      0.8450098633766174f,
      0.8424324989318848f,
      0.8398773074150085f,
      0.837332010269165f,
      0.8348090052604675f,
      0.8322899341583252f,
      0.8297901153564453f,
      0.8272949457168579f,
      0.8248292803764343f,
      0.8223952651023865f,
      0.8199321627616882f,
      0.8175209164619446f,
      0.8151203393936157f,
      0.8127100467681885f,
      0.8103369474411011f,
      0.8079510927200317f,
      0.8055998086929321f,
      0.8032541275024414f,
      0.8009384870529175f,
      0.7986142039299011f,
      0.7963138222694397f,
      0.794023871421814f,
      0.7917568683624268f,
      0.7894957065582275f,
      0.7872359752655029f,
      0.7850046753883362f,
      0.7827632427215576f,
      0.780563235282898f,
      0.7783754467964172f,
      0.7761781811714172f,
      0.7739938497543335f,
      0.7718440890312195f,
      0.7696950435638428f,
      0.7675509452819824f,
      0.7654231190681458f,
      0.7633078694343567f,
      0.7612106800079346f,
      0.7591174244880676f,
      0.7570306062698364f,
      0.7549625039100647f,
      0.7529008984565735f,
      0.7508677244186401f,
      0.7488330602645874f,
      0.7467980980873108f,
      0.7447925806045532f,
      0.74278724193573f,
      0.7408173680305481f,
      0.7388277649879456f,
      0.7368583679199219f,
      0.7348807454109192f,
      0.7329365015029907f,
      0.7310168743133545f,
      0.7290605902671814f,
      0.7271442413330078f,
      0.7252537608146667f,
      0.723365068435669f,
      0.7214744687080383f,
      0.7195754647254944f,
      0.717719554901123f,
      0.7158574461936951f,
      0.713990330696106f,
      0.712158203125f,
      0.7103239893913269f,
      0.7085238099098206f,
      0.7066835165023804f,
      0.7048863768577576f,
      0.703105628490448f,
      0.7013306617736816f,
      0.6995511651039124f,
      0.6977716684341431f,
      0.6960317492485046f,
      0.6942790746688843f,
      0.6925272941589355f,
      0.6907827854156494f,
      0.689068615436554f,
      0.6873651742935181f,
      0.6856591105461121f,
      0.683970034122467f,
      0.682276725769043f,
      0.6806155443191528f,
      0.6789562106132507f,
      0.6772914528846741f,
      0.6756145358085632f,
      0.6739996075630188f,
      0.6723521947860718f,
      0.6707189679145813f,
      0.6690943241119385f,
      0.667471170425415f,
      0.6658817529678345f,
      0.6642791628837585f,
      0.6627091765403748f,
      0.6610907316207886f,
      0.6595312356948853f,
      0.6579535007476807f,
      0.6563933491706848f,
      0.6548567414283752f,
      0.6533052921295166f,
      0.6517643928527832f,
      0.6502271294593811f,
      0.6487271189689636f,
      0.6471983194351196f,
      0.6456824541091919f,
      0.6441740393638611f,
      0.6427110433578491f,
      0.6412062644958496f,
      0.6397189497947693f,
      0.6382338404655457f,
      0.6368032097816467f,
      0.6353349089622498f,
      0.6338663101196289f,
      0.632414698600769f,
      0.6309645175933838f,
      0.6295638084411621f,
      0.6281326413154602f,
      0.6266577243804932f,
      0.6252782940864563f,
      0.6238624453544617f,
      0.6224457025527954f,
      0.6210411190986633f,
      0.6196972131729126f,
      0.6183050870895386f,
      0.6169123649597168f,
      0.6155316233634949f,
      0.6141581535339355f,
      0.6127851009368896f,
      0.6114739775657654f,
      0.6101250648498535f,
      0.6087701320648193f,
      0.6074327826499939f,
      0.6060886979103088f,
      0.6047580242156982f,
      0.6034865379333496f,
      0.6021608114242554f,
      0.6008508801460266f,
      0.5995306968688965f,
      0.5982363224029541f,
      0.5969292521476746f,
      0.5957053899765015f,
      0.5944206714630127f,
      0.5931257605552673f,
      0.5918459892272949f,
      0.5905752778053284f,
      0.5893149971961975f,
      0.5880455374717712f,
      0.5868629813194275f,
      0.5856124758720398f,
      0.584365963935852f,
      0.5831298828125f,
      0.5818825364112854f,
      0.5806562304496765f,
      0.5795091986656189f,
      0.5782133936882019f,
      0.5770759582519531f,
      0.5758540034294128f,
      0.5746507048606873f,
      0.5734581351280212f,
      0.572260856628418f,
      0.5711557865142822f,
      0.5699601173400879f,
      0.56878262758255f,
      0.5676038265228271f,
      0.5664293766021729f,
      0.5652664303779602f,
      0.5641055107116699f,
      0.5629429817199707f,
      0.5617981553077698f,
      0.560724675655365f,
      0.5595853328704834f,
      0.5584439039230347f,
      0.5573145747184753f,
      0.5561866164207458f,
      0.5550540685653687f,
      0.5539348125457764f,
      0.5528168678283691f,
      0.551703691482544f,
      0.5506914854049683f,
      0.5495861172676086f,
      0.5484772324562073f,
      0.5473835468292236f,
      0.5462953448295593f,
      0.5452186465263367f,
      0.5441282391548157f,
      0.5430482625961304f,
      0.5420768857002258f,
      0.5410019159317017f,
      0.5399383902549744f,
      0.5388686060905457f,
      0.5378226637840271f,
      0.5367569923400879f,
      0.5357192158699036f,
      0.5346730947494507f,
      0.5336322784423828f,
      0.5326928496360779f,
      0.5316630005836487f,
      0.530632495880127f,
      0.5296065211296082f,
      0.5285836458206177f,
      0.527567982673645f,
      0.5265474915504456f,
      0.5255448222160339f,
      0.5245286226272583f,
      0.523533046245575f,
      0.5226390957832336f,
      0.5216454267501831f,
      0.520652711391449f,
      0.5196588635444641f,
      0.5186789631843567f,
      0.5176900029182434f,
      0.5167258381843567f,
      0.5157418847084045f,
      0.5147818326950073f,
      0.5139275193214417f,
      0.5129619836807251f,
      0.5119994282722473f,
      0.5110417008399963f,
      0.5100873708724976f,
      0.509143054485321f,
      0.5081951022148132f,
      0.5072543621063232f,
      0.5063202977180481f,
      0.5053861141204834f,
      0.504448652267456f,
      0.5036346316337585f,
      0.5027136206626892f,
      0.5017893314361572f,
      0.5008748173713684f,
      0.499958872795105f,
      0.49904754757881165f,
      0.4981437027454376f,
      0.49722805619239807f,
      0.496323823928833f,
      0.4954327642917633f,
      0.49453726410865784f,
      0.4936388432979584f,
      0.49287769198417664f,
      0.49198541045188904f,
      0.491106778383255f,
      0.49022388458251953f,
      0.4893478751182556f,
      0.4884764850139618f,
      0.4875950813293457f,
      0.4867376685142517f,
      0.48586568236351013f,
      0.4850086271762848f,
      0.48428311944007874f,
      0.4834233224391937f,
      0.48257315158843994f,
      0.4817160367965698f,
      0.48087117075920105f,
      0.4800178110599518f,
      0.4791848361492157f,
      0.4783398509025574f,
      0.477504700422287f,
      0.47667381167411804f,
      0.4758389890193939f,
      0.47501859068870544f,
      0.47420215606689453f,
      0.47351062297821045f,
      0.47269147634506226f,
      0.4718797504901886f,
      0.4710562527179718f,
      0.470244437456131f,
      0.4694313108921051f,
      0.46862855553627014f,
      0.46783313155174255f,
      0.4670245349407196f,
      0.46622806787490845f,
      0.4654315114021301f,
      0.4646444320678711f,
      0.46400779485702515f,
      0.46321550011634827f,
      0.4624347388744354f,
      0.4616488814353943f,
      0.4608704447746277f,
      0.4600817561149597f,
      0.4593166410923004f,
      0.45854735374450684f,
      0.4577728509902954f,
      0.4570140838623047f,
      0.45624762773513794f,
      0.4554744064807892f,
      0.4547233581542969f,
      0.45396924018859863f,
      0.4532163143157959f,
      0.4524644613265991f,
      0.45186465978622437f,
      0.451113760471344f,
      0.45037031173706055f,
      0.44962790608406067f,
      0.4488859474658966f,
      0.4481387436389923f,
      0.44741424918174744f,
      0.44668450951576233f,
      0.4459531903266907f,
      0.4452272355556488f,
      0.4444943368434906f,
      0.44376522302627563f,
      0.4430609941482544f,
      0.4423399269580841f,
      0.44162437319755554f,
      0.44092077016830444f,
      0.44035348296165466f,
      0.43963125348091125f,
      0.43893131613731384f,
      0.43821457028388977f,
      0.4375140964984894f,
      0.43682199716567993f,
      0.4361187517642975f,
      0.43542149662971497f,
      0.4347245991230011f,
      0.43403711915016174f,
      0.4333515167236328f,
      0.43265432119369507f,
      0.43198055028915405f,
      0.43129345774650574f,
      0.43061575293540955f,
      0.42994552850723267f,
      0.42940711975097656f,
      0.42858874797821045f,
      0.4280592203140259f,
      0.4273867607116699f,
      0.42671313881874084f,
      0.42605599761009216f,
      0.42539089918136597f,
      0.4247209131717682f,
      0.4240663945674896f,
      0.42341148853302f,
      0.42275765538215637f,
      0.42209509015083313f,
      0.42143765091896057f,
      0.42080140113830566f,
      0.4201468527317047f,
      0.4194980561733246f,
      0.4188656210899353f,
      0.41821470856666565f,
      0.41772547364234924f,
      0.41709259152412415f,
      0.41644570231437683f,
      0.4158170521259308f,
      0.41517263650894165f,
      0.4145396947860718f,
      0.41391560435295105f,
      0.4132928252220154f,
      0.4126638174057007f,
      0.4120407700538635f,
      0.41142719984054565f,
      0.41079431772232056f,
      0.41018378734588623f,
      0.40957632660865784f,
      0.4089510440826416f,
      0.40834856033325195f,
      0.4077397584915161f,
      0.40713584423065186f,
      0.40653058886528015f,
      0.40591660141944885f,
      0.40545427799224854f,
      0.40484878420829773f,
      0.4042467474937439f,
      0.40365779399871826f,
      0.40306055545806885f,
      0.4024546444416046f,
      0.40186887979507446f,
      0.4012792706489563f,
      0.4006851613521576f,
      0.40009668469429016f,
      0.39951032400131226f,
      0.39892905950546265f,
      0.39835870265960693f,
      0.39776912331581116f,
      0.39719560742378235f,
      0.396615594625473f,
      0.3960385322570801f,
      0.3954774737358093f,
      0.3949020504951477f,
      0.39445599913597107f,
      0.3938904106616974f,
      0.39331844449043274f,
      0.392758309841156f,
      0.39219677448272705f,
      0.3916293978691101f,
      0.3910665214061737f,
      0.39050790667533875f,
      0.389950692653656f,
      0.3893989324569702f,
      0.38883399963378906f,
      0.38829392194747925f,
      0.38773322105407715f,
      0.3871852457523346f,
      0.3866378366947174f,
      0.3860984444618225f,
      0.3855457901954651f,
      0.38500967621803284f,
      0.3844599723815918f,
      0.3839244246482849f,
      0.3833819627761841f,
      0.3829789459705353f,
      0.3824446201324463f,
      0.3819071352481842f,
      0.38137343525886536f,
      0.38084131479263306f,
      0.3802966773509979f,
      0.37978115677833557f,
      0.3792538046836853f,
      0.37872761487960815f,
      0.3782009482383728f,
      0.377670556306839f,
      0.3771509826183319f,
      0.37663358449935913f,
      0.37611761689186096f,
      0.37560227513313293f,
      0.37509289383888245f,
      0.3745761811733246f,
      0.3740687668323517f,
      0.3735479414463043f,
      0.3730413317680359f,
      0.37265872955322266f,
      0.3720226287841797f,
      0.371643602848053f,
      0.3711407780647278f,
      0.3706258535385132f,
      0.37013667821884155f,
      0.36963024735450745f,
      0.36912256479263306f,
      0.3686225712299347f,
      0.36813730001449585f,
      0.36763039231300354f,
      0.3671342730522156f,
      0.36665064096450806f,
      0.36616051197052f,
      0.36566630005836487f,
      0.3651680648326874f,
      0.36469766497612f,
      0.364213764667511f,
      0.3637215793132782f,
      0.3632481098175049f,
      0.36276188492774963f,
      0.3624085783958435f,
      0.36179980635643005f,
      0.36132243275642395f,
      0.36096569895744324f,
      0.3604854941368103f,
      0.3600185513496399f,
      0.35954388976097107f,
      0.3590605556964874f,
      0.35858938097953796f,
      0.3581317067146301f,
      0.35764870047569275f,
      0.3571859896183014f,
      0.3567151129245758f,
      0.35624682903289795f,
      0.35578250885009766f,
      0.3553260564804077f,
      0.35486695170402527f,
      0.354401171207428f,
      0.3539525270462036f,
      0.35349583625793457f,
      0.35302644968032837f,
      0.35258957743644714f,
      0.3521282970905304f,
      0.351673424243927f,
      0.35122764110565186f,
      0.35089540481567383f,
      0.35032305121421814f,
      0.3499942719936371f,
      0.349543035030365f,
      0.3491019904613495f,
      0.3486470580101013f,
      0.348204106092453f,
      0.3477635979652405f,
      0.34731149673461914f,
      0.34688109159469604f,
      0.34642982482910156f,
      0.34599629044532776f,
      0.3455651104450226f,
      0.3451215326786041f,
      0.3446847200393677f,
      0.34426259994506836f,
      0.3438153564929962f,
      0.3433886766433716f,
      0.34296250343322754f,
      0.3425285518169403f,
      0.3421013653278351f,
      0.3416734039783478f,
      0.3412553071975708f,
      0.34082120656967163f,
      0.3404068648815155f,
      0.3401075303554535f,
      0.3396795988082886f,
      0.33924874663352966f,
      0.33882710337638855f,
      0.33841201663017273f,
      0.33799099922180176f,
      0.33757779002189636f,
      0.3371507525444031f,
      0.3367448151111603f,
      0.3363204598426819f,
      0.33589497208595276f,
      0.33549508452415466f,
      0.33507639169692993f,
      0.33468082547187805f,
      0.3342556953430176f,
      0.3338509202003479f,
      0.3334386944770813f,
      0.3330461084842682f,
      0.33263781666755676f,
      0.33223792910575867f,
      0.3318367898464203f,
      0.33143073320388794f,
      0.33102700114250183f,
      0.3306204378604889f,
      0.33022868633270264f,
      0.3299452066421509f,
      0.32943421602249146f,
      0.3291661739349365f,
      0.3287597894668579f,
      0.3283606767654419f,
      0.3279717266559601f,
      0.3275641202926636f,
      0.32717373967170715f,
      0.32678133249282837f,
      0.3263908326625824f,
      0.32599589228630066f,
      0.3256118595600128f,
      0.32522615790367126f,
      0.3248441517353058f,
      0.32444849610328674f,
      0.32406193017959595f,
      0.3236929178237915f,
      0.32330766320228577f,
      0.32291358709335327f,
      0.3225407600402832f,
      0.3221597671508789f,
      0.3217817544937134f,
      0.3214161992073059f,
      0.3210352659225464f,
      0.32065457105636597f,
      0.3202817738056183f,
      0.3199090361595154f,
      0.31952476501464844f,
      0.319169282913208f,
      0.3187875747680664f,
      0.3185270428657532f,
      0.3181511163711548f,
      0.317775696516037f,
      0.3174203932285309f,
      0.3170458972454071f,
      0.31666886806488037f,
      0.3162999153137207f,
      0.3159377872943878f,
      0.31556838750839233f,
      0.31520411372184753f,
      0.3148469030857086f,
      0.3144857883453369f,
      0.3141215145587921f,
      0.31376320123672485f,
      0.31340187788009644f,
      0.3130473494529724f,
      0.31268247961997986f,
      0.31231939792633057f,
      0.3119741976261139f,
      0.3116225302219391f,
      0.31126993894577026f,
      0.31091198325157166f,
      0.31057122349739075f,
      0.31021246314048767f,
      0.3098519444465637f,
      0.3094977140426636f,
      0.3091588318347931f,
      0.30892714858055115f,
      0.30857694149017334f,
      0.3082209527492523f,
      0.3078847825527191f,
      0.3075329661369324f,
      0.3071773946285248f,
      0.30683404207229614f,
      0.3064839243888855f,
      0.3061547875404358f,
      0.30579352378845215f,
      0.30546462535858154f,
      0.30512529611587524f,
      0.30477094650268555f,
      0.3044355809688568f,
      0.30408528447151184f,
      0.3037561774253845f,
      0.3034191131591797f,
      0.3030731678009033f,
      0.30274105072021484f,
      0.30242061614990234f,
      0.30208802223205566f,
      0.3017595112323761f,
      0.3014223575592041f,
      0.30109384655952454f,
      0.3007519543170929f,
      0.3004204034805298f,
      0.30008986592292786f,
      0.299759179353714f,
      0.299442321062088f,
      0.2991182208061218f,
      0.29890474677085876f,
      0.2984606623649597f,
      0.2982538938522339f,
      0.2979181706905365f,
      0.29759877920150757f,
      0.29726243019104004f,
      0.296941339969635f,
      0.29661667346954346f,
      0.29628586769104004f,
      0.29597124457359314f,
      0.2956542372703552f,
      0.29532766342163086f,
      0.2950131297111511f,
      0.2946982681751251f,
      0.29437026381492615f,
      0.294062077999115f,
      0.29373520612716675f,
      0.29342857003211975f,
      0.29311829805374146f,
      0.2927953600883484f,
      0.29248350858688354f,
      0.2921796143054962f,
      0.29186367988586426f,
      0.29155081510543823f,
      0.29124289751052856f,
      0.2909250855445862f,
      0.29062604904174805f,
      0.2903158664703369f,
      0.2900070548057556f,
      0.2897077798843384f,
      0.28951889276504517f,
      0.2892034649848938f,
      0.2888925075531006f,
      0.288595587015152f,
      0.28828054666519165f,
      0.2879889905452728f,
      0.28767019510269165f,
      0.28737157583236694f,
      0.2870650291442871f,
      0.2867684066295624f,
      0.28646013140678406f,
      0.2861575782299042f,
      0.2858670949935913f,
      0.2855522036552429f,
      0.28526467084884644f,
      0.28496551513671875f,
      0.2846636176109314f,
      0.284365713596344f,
      0.28407022356987f,
      0.2837750017642975f,
      0.28347358107566833f,
      0.2831934988498688f,
      0.2828976511955261f,
      0.28260302543640137f,
      0.28230583667755127f,
      0.28202950954437256f,
      0.2817310094833374f,
      0.28143706917762756f,
      0.28114718198776245f,
      0.2808639705181122f,
      0.28057390451431274f,
      0.28029951453208923f,
      0.280012309551239f,
      0.2798384428024292f,
      0.2795555889606476f,
      0.2792515158653259f,
      0.2789651155471802f,
      0.27868083119392395f,
      0.2783908545970917f,
      0.2781171500682831f,
      0.27781638503074646f,
      0.27753525972366333f,
      0.2772636413574219f,
      0.27696749567985535f,
      0.2766968011856079f,
      0.27640965580940247f,
      0.2761270999908447f,
      0.27586647868156433f,
      0.2755773663520813f,
      0.2752978801727295f,
      0.27502650022506714f,
      0.27474793791770935f,
      0.27447831630706787f,
      0.2741829454898834f,
      0.27391597628593445f,
      0.2736358046531677f,
      0.273369163274765f,
      0.2731073796749115f,
      0.2728367745876312f,
      0.27255797386169434f,
      0.2722831964492798f,
      0.27201396226882935f,
      0.27174121141433716f,
      0.2714810073375702f,
      0.271202027797699f,
      0.27105721831321716f,
      0.2706688344478607f,
      0.27050918340682983f,
      0.27024585008621216f,
      0.26997825503349304f,
      0.269709050655365f,
      0.2694370150566101f,
      0.269164115190506f,
      0.2688915729522705f,
      0.2686392366886139f,
      0.26836714148521423f,
      0.26810500025749207f,
      0.2678486406803131f,
      0.26756900548934937f,
      0.26730361580848694f,
      0.2670464813709259f,
      0.2668019235134125f,
      0.2665204405784607f,
      0.2662788927555084f,
      0.26599955558776855f,
      0.26575011014938354f,
      0.2655024230480194f,
      0.2652343511581421f,
      0.26497983932495117f,
      0.2647083103656769f,
      0.2644578218460083f,
      0.2642085552215576f,
      0.26395532488822937f,
      0.26370131969451904f,
      0.263449490070343f,
      0.263189435005188f,
      0.26294055581092834f,
      0.26268911361694336f,
      0.26243090629577637f,
      0.2621835768222809f,
      0.26193270087242126f,
      0.2616826891899109f,
      0.2615540623664856f,
      0.26129040122032166f,
      0.2610347867012024f,
      0.2607840299606323f,
      0.26054710149765015f,
      0.26027703285217285f,
      0.2600274682044983f,
      0.2597811222076416f,
      0.2595488429069519f,
      0.25929802656173706f,
      0.25903254747390747f,
      0.25879475474357605f,
      0.2585379481315613f,
      0.2582918405532837f,
      0.25805673003196716f,
      0.2578195035457611f,
      0.257572203874588f,
      0.25732144713401794f,
      0.25707995891571045f,
      0.25684061646461487f,
      0.2565879821777344f,
      0.2563695013523102f,
      0.25612086057662964f,
      0.25587913393974304f,
      0.255633145570755f,
      0.25540968775749207f,
      0.2551721930503845f,
      0.2549220621585846f,
      0.254700630903244f,
      0.25446105003356934f,
      0.2542218565940857f,
      0.2539829611778259f,
      0.25375211238861084f,
      0.2535262703895569f,
      0.2532768249511719f,
      0.2531611919403076f,
      0.25292646884918213f,
      0.25268787145614624f,
      0.2524307668209076f,
      0.2521924376487732f,
      0.2519637644290924f,
      0.25172385573387146f,
      0.2515079975128174f,
      0.25126898288726807f,
      0.2510269284248352f,
      0.2507886588573456f,
      0.25056445598602295f,
      0.2503352165222168f,
      0.25009676814079285f,
      0.2498702108860016f,
      0.24963845312595367f,
      0.24942903220653534f,
      0.24918432533740997f,
      0.24895094335079193f,
      0.24872754514217377f,
      0.24850548803806305f,
      0.24829132854938507f,
      0.24806000292301178f,
      0.24783314764499664f,
      0.24762097001075745f,
      0.24738754332065582f,
      0.247167706489563f,
      0.24695299565792084f,
      0.2467201054096222f,
      0.24649381637573242f,
      0.24628238379955292f,
      0.246060311794281f,
      0.24583758413791656f,
      0.24561069905757904f,
      0.24550525844097137f,
      0.24525107443332672f,
      0.2450413703918457f,
      0.2447965145111084f,
      0.24457761645317078f,
      0.244342640042305f,
      0.24413128197193146f,
      0.24391278624534607f,
      0.24368220567703247f,
      0.2434716671705246f,
      0.24324753880500793f,
      0.24301570653915405f,
      0.2428036779165268f,
      0.24259786307811737f,
      0.24236488342285156f,
      0.242148756980896f,
      0.2419562190771103f,
      0.2417379468679428f,
      0.24150964617729187f,
      0.24130253493785858f,
      0.24109186232089996f,
      0.2408781796693802f,
      0.24066923558712006f,
      0.2404642105102539f,
      0.2402576357126236f,
      0.24005992710590363f,
      0.23985056579113007f,
      0.2396526038646698f,
      0.23944325745105743f,
      0.23922142386436462f,
      0.2390366494655609f,
      0.23881308734416962f,
      0.23860570788383484f,
      0.2384617030620575f,
      0.23822690546512604f,
      0.2379762977361679f,
      0.2377336621284485f,
      0.23748332262039185f,
      0.23739533126354218f,
      0.23720183968544006f,
      0.23698101937770844f,
      0.2367992401123047f,
      0.23657922446727753f,
      0.2363961786031723f,
      0.23619228601455688f,
      0.23597639799118042f,
      0.23578175902366638f,
      0.23557808995246887f,
      0.2353663593530655f,
      0.23517079651355743f,
      0.23498423397541046f,
      0.23477226495742798f,
      0.23457729816436768f,
      0.23437486588954926f,
      0.23418821394443512f,
      0.23396605253219604f,
      0.23378512263298035f,
      0.23358199000358582f,
      0.2333938032388687f,
      0.23318566381931305f,
      0.232975572347641f,
      0.23278391361236572f,
      0.23260772228240967f,
      0.23240657150745392f,
      0.23220720887184143f,
      0.23199425637722015f,
      0.23182547092437744f,
      0.2316315621137619f,
      0.2314368188381195f,
      0.2312292903661728f,
      0.23103848099708557f,
      0.23084689676761627f,
      0.2306482344865799f,
      0.2303827702999115f,
      0.23021303117275238f,
      0.23004060983657837f,
      0.22985106706619263f,
      0.22975048422813416f,
      0.22943352162837982f,
      0.22933898866176605f,
      0.22914543747901917f,
      0.22899281978607178f,
      0.2288072258234024f,
      0.22861431539058685f,
      0.22843509912490845f,
      0.22816847264766693f,
      0.22806860506534576f,
      0.22780157625675201f,
      0.22762224078178406f,
      0.22741560637950897f,
      0.22724071145057678f,
      0.22705252468585968f,
      0.2268504947423935f,
      0.22666625678539276f,
      0.22649532556533813f,
      0.22630980610847473f,
      0.226119264960289f,
      0.22594040632247925f,
      0.22574901580810547f,
      0.22555193305015564f,
      0.22536906599998474f,
      0.22519013285636902f,
      0.2250993400812149f,
      0.2249121069908142f,
      0.2246369868516922f,
      0.2244608998298645f,
      0.22436270117759705f,
      0.22417575120925903f,
      0.22398057579994202f,
      0.22379761934280396f,
      0.2236267328262329f,
      0.22343775629997253f,
      0.2232411950826645f,
      0.2230568677186966f,
      0.2228923738002777f,
      0.2226988673210144f,
      0.22252492606639862f,
      0.222340390086174f,
      0.22216126322746277f,
      0.22196727991104126f,
      0.2217983901500702f,
      0.22159728407859802f,
      0.2214152216911316f,
      0.22124730050563812f,
      0.22106245160102844f,
      0.22088639438152313f,
      0.22071680426597595f,
      0.22053596377372742f,
      0.22036345303058624f,
      0.2201765477657318f,
      0.21999706327915192f,
      0.21981528401374817f,
      0.219647616147995f,
      0.21948128938674927f,
      0.21930661797523499f,
      0.21912866830825806f,
      0.2189987599849701f,
      0.21882392466068268f,
      0.21860471367835999f,
      0.2184319645166397f,
      0.21827076375484467f,
      0.21810099482536316f,
      0.21792113780975342f,
      0.2177520990371704f,
      0.21756581962108612f,
      0.21740955114364624f,
      0.21723714470863342f,
      0.21705415844917297f,
      0.2168884575366974f,
      0.21672160923480988f,
      0.21655923128128052f,
      0.21638694405555725f,
      0.21622954308986664f,
      0.21604597568511963f,
      0.2158840000629425f,
      0.21571625769138336f,
      0.2155391424894333f,
      0.21538583934307098f,
      0.21519944071769714f,
      0.21505311131477356f,
      0.21487067639827728f,
      0.21470613777637482f,
      0.21453726291656494f,
      0.21436457335948944f,
      0.2142084687948227f,
      0.21404136717319489f,
      0.21386931836605072f,
      0.21371158957481384f,
      0.21354614198207855f,
      0.21337896585464478f,
      0.21321818232536316f,
      0.21306107938289642f,
      0.21288613975048065f,
      0.21270926296710968f,
      0.21254965662956238f,
      0.21240270137786865f,
      0.21222689747810364f,
      0.21206718683242798f,
      0.21189945936203003f,
      0.21174396574497223f,
      0.21158431470394135f,
      0.21141672134399414f,
      0.21126426756381989f,
      0.21110302209854126f,
      0.21093645691871643f,
      0.21075579524040222f,
      0.21061968803405762f,
      0.21045085787773132f,
      0.21029168367385864f,
      0.21012543141841888f,
      0.20997537672519684f,
      0.20979711413383484f,
      0.2096484750509262f,
      0.20949453115463257f,
      0.20933128893375397f,
      0.2092391550540924f,
      0.20908373594284058f,
      0.20891214907169342f,
      0.20874397456645966f,
      0.20856574177742004f,
      0.2084084302186966f,
      0.20823991298675537f,
      0.20807170867919922f,
      0.2079344242811203f,
      0.20777527987957f,
      0.20760463178157806f,
      0.2074466198682785f,
      0.20728443562984467f,
      0.20711849629878998f,
      0.20704475045204163f,
      0.20681829750537872f,
      0.206665500998497f,
      0.20651502907276154f,
      0.20636317133903503f,
      0.20621225237846375f,
      0.20606686174869537f,
      0.20590756833553314f,
      0.20575928688049316f,
      0.20561814308166504f,
      0.20545589923858643f,
      0.20531953871250153f,
      0.20517383515834808f,
      0.20502527058124542f,
      0.20486554503440857f,
      0.20473383367061615f,
      0.20456953346729279f,
      0.20443563163280487f,
      0.2042897790670395f,
      0.20412671566009521f,
      0.203985333442688f,
      0.20382718741893768f,
      0.20369099080562592f,
      0.20347239077091217f,
      0.20331762731075287f,
      0.20316165685653687f,
      0.20309443771839142f,
      0.20288388431072235f,
      0.20273058116436005f,
      0.20257724821567535f,
      0.2024327665567398f,
      0.2023533135652542f,
      0.20212598145008087f,
      0.20199725031852722f,
      0.20184215903282166f,
      0.201684832572937f,
      0.20153000950813293f,
      0.20138248801231384f,
      0.20132234692573547f,
      0.20110218226909637f,
      0.20095877349376678f,
      0.20080117881298065f,
      0.20065566897392273f,
      0.20058509707450867f,
      0.20044000446796417f,
      0.20022062957286835f,
      0.2001517117023468f,
      0.1999906450510025f,
      0.19985084235668182f,
      0.19970712065696716f,
      0.1995593160390854f,
      0.19940970838069916f,
      0.19925720989704132f,
      0.19912421703338623f,
      0.19896483421325684f,
      0.1988271027803421f,
      0.1986902952194214f,
      0.19854453206062317f,
      0.1983991265296936f,
      0.19824765622615814f,
      0.19809825718402863f,
      0.19794441759586334f,
      0.19781728088855743f,
      0.197679340839386f,
      0.19752560555934906f,
      0.19738903641700745f,
      0.19724692404270172f,
      0.19710291922092438f,
      0.19694319367408752f,
      0.19679763913154602f,
      0.19667893648147583f,
      0.19654053449630737f,
      0.19639882445335388f,
      0.1962447166442871f,
      0.19611676037311554f,
      0.19597302377223969f,
      0.1958155632019043f,
      0.19569317996501923f,
      0.19554798305034637f,
      0.19546417891979218f,
      0.19531387090682983f,
      0.1951518952846527f,
      0.19500510394573212f,
      0.1948569416999817f,
      0.1947188377380371f,
      0.19457601010799408f,
      0.1944355070590973f,
      0.1943163275718689f,
      0.19419316947460175f,
      0.19406013190746307f,
      0.1939316838979721f,
      0.19380061328411102f,
      0.19361799955368042f,
      0.19356895983219147f,
      0.19335971772670746f,
      0.19322030246257782f,
      0.19309407472610474f,
      0.19295793771743774f,
      0.19282597303390503f,
      0.1926853209733963f,
      0.19256816804409027f,
      0.19241055846214294f,
      0.19227875769138336f,
      0.19216206669807434f,
      0.19201426208019257f,
      0.19190306961536407f,
      0.19177010655403137f,
      0.19164131581783295f,
      0.19150659441947937f,
      0.19136707484722137f,
      0.19123968482017517f,
      0.19109953939914703f,
      0.19096407294273376f,
      0.19085878133773804f,
      0.19072504341602325f,
      0.19058534502983093f,
      0.19044341146945953f,
      0.19033217430114746f,
      0.19019955396652222f,
      0.1900748461484909f,
      0.18993522226810455f,
      0.18979689478874207f,
      0.18968908488750458f,
      0.18955446779727936f,
      0.1894242912530899f,
      0.1892847716808319f,
      0.18915081024169922f,
      0.18904006481170654f,
      0.18889068067073822f,
      0.188766211271286f,
      0.18864603340625763f,
      0.18851563334465027f,
      0.18837957084178925f,
      0.18825824558734894f,
      0.18812908232212067f,
      0.188008114695549f,
      0.1878795325756073f,
      0.1877526491880417f,
      0.18760880827903748f,
      0.18748433887958527f,
      0.18736301362514496f,
      0.1872415989637375f,
      0.18709830939769745f,
      0.18698199093341827f,
      0.18684744834899902f,
      0.18671074509620667f,
      0.18659581243991852f,
      0.18647025525569916f,
      0.18634554743766785f,
      0.1862228959798813f,
      0.18607831001281738f,
      0.18597042560577393f,
      0.18583640456199646f,
      0.1857118457555771f,
      0.18556807935237885f,
      0.18546096980571747f,
      0.18533286452293396f,
      0.1851893812417984f,
      0.18508218228816986f,
      0.18495319783687592f,
      0.18483921885490417f,
      0.18468913435935974f,
      0.18456900119781494f,
      0.1844482123851776f,
      0.1843346208333969f,
      0.18426157534122467f,
      0.18407920002937317f,
      0.1840098649263382f,
      0.18388019502162933f,
      0.1837506741285324f,
      0.18361012637615204f,
      0.18349850177764893f,
      0.18336111307144165f,
      0.18322956562042236f,
      0.1831212341785431f,
      0.18299393355846405f,
      0.18287387490272522f,
      0.18273331224918365f,
      0.18260888755321503f,
      0.18251749873161316f,
      0.1823824644088745f,
      0.1822899878025055f,
      0.18214130401611328f,
      0.18202616274356842f,
      0.18194933235645294f,
      0.18176619708538055f,
      0.18166181445121765f,
      0.18153472244739532f,
      0.18141895532608032f,
      0.1813163310289383f,
      0.18119414150714874f,
      0.18106402456760406f,
      0.18096478283405304f,
      0.1808406263589859f,
      0.18074311316013336f,
      0.180620476603508f,
      0.18049950897693634f,
      0.18039359152317047f,
      0.18029093742370605f,
      0.18012148141860962f,
      0.18005935847759247f,
      0.1798868477344513f,
      0.1797729879617691f,
      0.17966116964817047f,
      0.1795545071363449f,
      0.17941901087760925f,
      0.17930275201797485f,
      0.179204523563385f,
      0.17909133434295654f,
      0.1789587140083313f,
      0.1788659393787384f,
      0.17874272167682648f,
      0.17861700057983398f,
      0.17850957810878754f,
      0.17839275300502777f,
      0.17828509211540222f,
      0.17817743122577667f,
      0.1780514270067215f,
      0.17793850600719452f,
      0.1778256744146347f,
      0.17772488296031952f,
      0.17760786414146423f,
      0.17749641835689545f,
      0.17738603055477142f,
      0.17726750671863556f,
      0.17714694142341614f,
      0.17701052129268646f,
      0.17691530287265778f,
      0.1767774522304535f,
      0.17667871713638306f,
      0.17658495903015137f,
      0.17645849287509918f,
      0.17634360492229462f,
      0.17621174454689026f,
      0.17608866095542908f,
      0.17599357664585114f,
      0.17587827146053314f,
      0.17576055228710175f,
      0.175655335187912f,
      0.1755446493625641f,
      0.17543494701385498f,
      0.17532062530517578f,
      0.17520667612552643f,
      0.1750895380973816f,
      0.1749843806028366f,
      0.17488902807235718f,
      0.17476396262645721f,
      0.17466075718402863f,
      0.17455172538757324f,
      0.17443951964378357f,
      0.1743200421333313f,
      0.17422179877758026f,
      0.1741151660680771f,
      0.17399916052818298f,
      0.17389005422592163f,
      0.17378292977809906f,
      0.17365168035030365f,
      0.1735643893480301f,
      0.17345161736011505f,
      0.17334435880184174f,
      0.17317555844783783f,
      0.17308492958545685f,
      0.17301665246486664f,
      0.172912135720253f,
      0.1727500706911087f,
      0.1726379096508026f,
      0.1725439578294754f,
      0.1724371612071991f,
      0.172346293926239f,
      0.1722460836172104f,
      0.1721653789281845f,
      0.17207512259483337f,
      0.1719343364238739f,
      0.17184847593307495f,
      0.17173130810260773f,
      0.1716267615556717f,
      0.1715201884508133f,
      0.17139986157417297f,
      0.1713264435529709f,
      0.17120003700256348f,
      0.1711057722568512f,
      0.17097318172454834f,
      0.1709117293357849f,
      0.170778289437294f,
      0.17065805196762085f,
      0.17059460282325745f,
      0.17044983804225922f,
      0.1703534573316574f,
      0.17024719715118408f,
      0.1701587438583374f,
      0.17005027830600739f,
      0.1699545681476593f,
      0.1698647290468216f,
      0.16972842812538147f,
      0.1696062833070755f,
      0.16952422261238098f,
      0.16942402720451355f,
      0.16932529211044312f,
      0.1692180186510086f,
      0.1691202074289322f,
      0.1690051257610321f,
      0.16890999674797058f,
      0.16873781383037567f,
      0.1686418503522873f,
      0.16858814656734467f,
      0.168486550450325f,
      0.16837002336978912f,
      0.16828465461730957f,
      0.16817285120487213f,
      0.16806656122207642f,
      0.16796700656414032f,
      0.1678745001554489f,
      0.16775332391262054f,
      0.16765537858009338f,
      0.1675591617822647f,
      0.16747041046619415f,
      0.1673678755760193f,
      0.1672484427690506f,
      0.16713744401931763f,
      0.1670568436384201f,
      0.166981503367424f,
      0.16686902940273285f,
      0.1667419672012329f,
      0.16664457321166992f,
      0.1665564775466919f,
      0.16647207736968994f,
      0.16634348034858704f,
      0.1662454456090927f,
      0.16615059971809387f,
      0.166051983833313f,
      0.16595247387886047f,
      0.16585102677345276f,
      0.16576287150382996f,
      0.16566291451454163f,
      0.1655881404876709f,
      0.16547399759292603f,
      0.1653909832239151f,
      0.16526654362678528f,
      0.16514107584953308f,
      0.16506506502628326f,
      0.16495540738105774f,
      0.16488070785999298f,
      0.16478398442268372f,
      0.1646747887134552f,
      0.1645614057779312f,
      0.16447368264198303f,
      0.1643751710653305f,
      0.16422320902347565f,
      0.16416305303573608f,
      0.16406656801700592f,
      0.16399171948432922f,
      0.16390185058116913f,
      0.16380050778388977f,
      0.16370728611946106f,
      0.1636231541633606f,
      0.16353783011436462f,
      0.16339172422885895f,
      0.16329428553581238f,
      0.16320785880088806f,
      0.16310438513755798f,
      0.162996307015419f,
      0.16291500627994537f,
      0.16280920803546906f,
      0.16276128590106964f,
      0.16262003779411316f,
      0.16251814365386963f,
      0.16247931122779846f,
      0.16236905753612518f,
      0.1622738242149353f,
      0.162176251411438f,
      0.16205555200576782f,
      0.1619701385498047f,
      0.16187423467636108f,
      0.1617640107870102f,
      0.16167600452899933f,
      0.16152667999267578f,
      0.16149695217609406f,
      0.16139891743659973f,
      0.16133636236190796f,
      0.16123801469802856f,
      0.16111208498477936f,
      0.16100721061229706f,
      0.1609351634979248f,
      0.16081742942333221f,
      0.16075046360492706f,
      0.16062086820602417f,
      0.16053594648838043f,
      0.16046448051929474f,
      0.16038621962070465f,
      0.1602899432182312f,
      0.16022361814975739f,
      0.16006498038768768f,
      0.15998610854148865f,
      0.1599012315273285f,
      0.15978874266147614f,
      0.15971818566322327f,
      0.159612774848938f,
      0.15951795876026154f,
      0.159441277384758f,
      0.15937113761901855f,
      0.15927980840206146f,
      0.15915848314762115f,
      0.1590811163187027f,
      0.15896807610988617f,
      0.15888026356697083f,
      0.1588025689125061f,
      0.15870055556297302f,
      0.15861180424690247f,
      0.15851162374019623f,
      0.15843529999256134f,
      0.158340722322464f,
      0.15825113654136658f,
      0.1581512838602066f,
      0.1580662578344345f,
      0.1579820066690445f,
      0.15790003538131714f,
      0.1578054577112198f,
      0.15771929919719696f,
      0.15765094757080078f,
      0.15755470097064972f,
      0.15743505954742432f,
      0.15739582479000092f,
      0.15726667642593384f,
      0.15718722343444824f,
      0.15706954896450043f,
      0.15697892010211945f,
      0.15689809620380402f,
      0.1568191945552826f,
      0.1567181497812271f,
      0.15664193034172058f,
      0.15655569732189178f,
      0.15646186470985413f,
      0.1563776433467865f,
      0.1562684029340744f,
      0.1561981588602066f,
      0.1560996174812317f,
      0.15602006018161774f,
      0.15591232478618622f,
      0.15583202242851257f,
      0.1557215303182602f,
      0.15566304326057434f,
      0.155582994222641f,
      0.1554775834083557f,
      0.15543542802333832f,
      0.15533870458602905f,
      0.15524140000343323f,
      0.15515199303627014f,
      0.15504392981529236f,
      0.15495333075523376f,
      0.15486815571784973f,
      0.15481671690940857f,
      0.15472613275051117f,
      0.1546209454536438f,
      0.15452353656291962f,
      0.1544453203678131f,
      0.1543676257133484f,
      0.1543036252260208f,
      0.1541830599308014f,
      0.15408775210380554f,
      0.15400461852550507f,
      0.1539064198732376f,
      0.15384244918823242f,
      0.1537523865699768f,
      0.15370213985443115f,
      0.1535928100347519f

    }; 
  }
}