using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class TransformAnimations:Resource
  {    
    [Export]
    public TransformCurve[] curves = new TransformCurve[ 0 ];

    [Export]
    public TimeLine timeline;

    public float GetMaxDuration( List<Vector3> randomizations )
    {      
      var d = 0f;
      
      for ( int i = 0; i < curves.Length; i++ )
      {
        d = Mathf.Max( d, curves[ i ].GetRandomizedEndTime( randomizations[ i ] ) );
      }

      return d;
      
    }
  }
}