using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  

  [Tool]
  [GlobalClass]
  public partial class TransformCurve:AnimationCurve3D,Animator
  {
    public void OnAnimatorStart(){}
    public void OnAnimatorEnd(){}
    public void OnAnimatorCancel(){}

    public enum OperatorMode
    {
      Replace,
      Add,
      Multiply
    }

    [Export]
    public TransformTarget transformTarget;

    [Export]
    public OperatorMode operatorMode;


    public AnimationMember animationMember => TransformTargets.ToAnimationMember( transformTarget );
    

    public void Apply( float time, Node3D node, Vector3 randomization, Vector3 originalValue )
    {
      var animatedValue = Sample( time, randomization );
      animatedValue = ApplyOperator( animatedValue, originalValue );

      TransformTargets.Set( animatedValue, node, transformTarget );
    }
    

    Vector3 ApplyOperator( Vector3 animated, Vector3 original )
    { 
      if ( OperatorMode.Replace == operatorMode )
      { 
        return animated;
      }
      else if ( OperatorMode.Add == operatorMode )
      {
        return animated + original;
      }
      else if ( OperatorMode.Multiply == operatorMode )
      {
        return animated * original;
      }

      return original;

    }

    
    


  }
}