using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{
  public class TransformData
  {
    public Vector3 position;
    public Vector3 rotation;
    public Vector3 scale;


    public TransformData Clone()
    {
      var data = new TransformData();
      data.position = position;
      data.rotation = rotation;
      data.scale = scale;
      return data;
    }

    public void Add( TransformData other )
    {
      position += other.position;
      rotation += other.rotation;
      scale    += other.scale;
    }


    public override string ToString()
    {
      return RJLog.Stringify( position ) + ", " + RJLog.Stringify( rotation ) + ", " + RJLog.Stringify( scale );
    } 

    public void Set( Node3D node, bool globalPosition = true, bool globalRotation = true )
    {
      TransformTargets.Set( position, node, TransformTargets.Position( globalPosition ) );
      TransformTargets.Set( rotation, node, TransformTargets.Rotation( globalRotation ) );
      TransformTargets.Set( scale,    node, TransformTargets.Scale() );
    }

    public void Get( Node3D node, bool globalPosition = true, bool globalRotation = true )
    {
      position = TransformTargets.Get( node, TransformTargets.Position( globalPosition ) );
      rotation = TransformTargets.Get( node, TransformTargets.Rotation( globalRotation ) );
      scale    = TransformTargets.Get( node, TransformTargets.Scale() );
    }

    public static TransformData From( Node3D n, bool globalPosition = true, bool globalRotation = true )
    {
      var td = new TransformData();
      td.Get( n, globalPosition, globalRotation );
      return td;
    }
  }

}
  