using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{
  public enum TransformTarget
  {
    Global_Position,
    Global_Rotation,
    Local_Position,
    Local_Rotation,
    Local_Scale
  }

 

  public class TransformTargets
  {
    public static TransformTarget Position( bool global = true )
    {
      return global ? TransformTarget.Global_Position : TransformTarget.Local_Position;
    }

    public static TransformTarget Rotation( bool global = true )
    {
      return global ? TransformTarget.Global_Rotation : TransformTarget.Local_Rotation;
    }

    public static TransformTarget Scale()
    {
      return TransformTarget.Local_Scale;
    }

    public static AnimationMember ToAnimationMember( TransformTarget target )
    {
      if ( TransformTarget.Local_Position == target || TransformTarget.Global_Position == target )
      {
        return AnimationMember.Position;
      }

      if ( TransformTarget.Local_Rotation == target || TransformTarget.Global_Rotation == target )
      {
        return AnimationMember.Rotation;
      }

      if ( TransformTarget.Local_Scale == target )
      {
        return AnimationMember.Scale;
      }

      return null;
    }  

    public static Vector3 Get( Node3D target, TransformTarget transformTarget )
    {
      if ( TransformTarget.Global_Position == transformTarget )
      { 
        return target.GlobalPosition;
      }
      else if ( TransformTarget.Global_Rotation == transformTarget )
      { 
        // RJLog.Log( "GlobalRotation => ", target.GlobalRotation );
        return target.GlobalRotation;
      }
      else if ( TransformTarget.Local_Position == transformTarget )
      { 
        return target.Position;
      }
      else if ( TransformTarget.Local_Rotation == transformTarget )
      { 
        // RJLog.Log( "Rotation => ", target.Rotation );
        return target.Rotation;
      }
      else if ( TransformTarget.Local_Scale == transformTarget )
      { 
        return target.Scale;
      }

      return Vector3.Zero;
    }

    public static void Set( Vector3 value, Node3D target, TransformTarget transformTarget )
    { 
      if ( TransformTarget.Global_Position == transformTarget )
      { 
        target.GlobalPosition = value;
      }
      else if ( TransformTarget.Global_Rotation == transformTarget )
      { 
        var rotation = target.GlobalRotation;
        target.GlobalRotation = value * MathX.DegreesToRadians;
        // RJLog.Log( "GlobalRotation = ", rotation, ">>", value, target.GlobalRotation );
      }
      else if ( TransformTarget.Local_Position == transformTarget )
      { 
        target.Position = value;
      }
      else if ( TransformTarget.Local_Rotation == transformTarget )
      { 
        var rotation = target.Rotation;
        target.Rotation = value * MathX.DegreesToRadians;
        // RJLog.Log( "Rotation = ", rotation, ">>", value, target.Rotation );
      }
      else if ( TransformTarget.Local_Scale == transformTarget )
      { 
        target.Scale = value;
      }

    }
  }
 
}