
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass ]
  public partial class TweenTimeCurve : TweenType
  {
    public static readonly TweenTimeCurve defaultCurve = new TweenTimeCurve();

    [Export]
    public float duration = 0.5f;

    [Export]
    public Curve curve = MathX.Curve( 0, 1 ); 

    public override float GetTweenDuration()
    {
      return duration;
    }

    public override float GetTweenPhaseForPhase( float phase )
    {
      return curve == null ? phase : curve.Sample( phase );
    }

  }
}
