using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class Wipe:SequenceAction  
  { 
    public enum Direction
    {
      In,
      Out
    }

    [Export]
    public Direction direction;

    [Export]
    public Duration duration;

    [Export]
    public WipeSettings wipeSettings;    

    protected override void _OnTrigger()
    {
      var wipeEffect = wipeSettings.wipeEffect;
      var compositor = wipeSettings.compositor;

      var tm = TimeLineManager.Get();

      var d = duration != null ? duration : SecondsDuration.Create( 1, TimeLineManager.Ensure( null ) );
      
      var actionID = DispatchStart(); 
    

      var effects = wipeEffect.GetEffects( compositor );
      var animations = wipeEffect.GetWipeAnimations( direction );

      
      wipeEffect.AddToCompositor( compositor );

      // this.LogInfo( "Start:", Time.GetTicksMsec() );
      
      
      TimeLineManager.ScheduleSpanIn( d.timeLine, 0, d.GetDurationInSeconds() , 
        ( span, type )=>
        {  
          if ( actionID == -1 )
          {
            return;
          }

          // this.LogInfo( "Wipe Update:", span.phase._FFF() );

          for ( int i = 0; i < effects.Count; i++ )
          {
            var fx = effects[ i ];
            var value = animations[ i ].GetLerpedValueAt( span.phase, Mathf.Lerp );
            fx.wipeState = value;

            // this.LogInfo( "Wipe[" + i + "]",  "value:", value );
          }          

          if ( type == TimeLineSpanUpdateType.End )
          {
            if ( Direction.Out == direction )
            {
              wipeEffect.RemoveFromCompositor( compositor );
            }

            DispatchEnd( actionID );            

            // this.LogInfo( "End:", Time.GetTicksMsec() );
          }

        },
        this
      );

    }

  }
}