using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class WipeEffect:Resource  
  { 
    protected abstract List<WipeCompositorEffect> _CreateEffects();    
    protected virtual void _ClearEffects()
    {
      _activeEffects = [];
    }

    protected List<WipeCompositorEffect> _activeEffects = [];
    public List<WipeCompositorEffect> activeEffects => _activeEffects;

    public virtual List<KeyFrameAnimation<float>> GetWipeAnimations( Wipe.Direction direction )
    {
      var list = new List<KeyFrameAnimation<float>>();

      var keyFrameAnimation = new KeyFrameAnimation<float>();

      if ( Wipe.Direction.In == direction )
      {
        keyFrameAnimation.Add( 0, 0 );
        keyFrameAnimation.Add( 1, 1 );
      }
      else
      {
        keyFrameAnimation.Add( 0, 1 );
        keyFrameAnimation.Add( 1, 0 );
      }
      
      for ( int i = 0; i < _activeEffects.Count; i++ )
      {
        list.Add( keyFrameAnimation ); 
      }

      return list;
    }
    

    public virtual List<WipeCompositorEffect> GetEffects( Compositor compositor )
    {
      if ( 
        _activeEffects != null && _activeEffects.Count > 0 && 
        compositor != null && compositor.CompositorEffects.Contains( _activeEffects[ 0 ] )
      )
      {
        return _activeEffects;
      }
      

      _activeEffects = _CreateEffects();
      

      return _activeEffects;
    }


    
    public void AddToCompositor( Compositor compositor )
    {
      
      var allEffects = compositor.CompositorEffects;
      
      if ( allEffects.Contains( _activeEffects[ 0 ] ) )
      {
        return;
      }

      allEffects.AddRange( _activeEffects );
      compositor.CompositorEffects = allEffects;      
    }

    public void RemoveFromCompositor( Compositor compositor )
    {
      var allEffects = compositor.CompositorEffects;

      for ( int i = 0; i < _activeEffects.Count; i++ )
      {
        allEffects.Remove( _activeEffects[ i ] );
      }

      _ClearEffects();

      compositor.CompositorEffects = allEffects;      
    }
  }
}