using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public abstract partial class BaseWipeEffect:WipeEffect  
  { 
    [ExportGroup("Color")]
    [Export]
    public Gradient wipeGradient = new Gradient();

    [ExportGroup("Blend Mode")]
    [Export]
    public float replace = 1.0f;

    [Export]
    public float add = 0.0f;

    [Export]
    public float multiply = 0.0f;

    [Export]
    public float colorize = 0.0f;

    [Export]
    public bool normalizeBlendWeights = true;

    protected void ApplyBaseWipeSettings( WipeCompositorEffect effect ) 
    {
      effect.wipeGradient = wipeGradient;
      effect.replace = replace;
      effect.add = add;
      effect.multiply = multiply;
      effect.colorize = colorize;
      effect.normalizeBlendWeights = normalizeBlendWeights;
    }

  }
}