using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class CircleWipe:BaseWipeEffect  
  { 
    [ExportGroup( "Circle" )]
    [Export( PropertyHint.Range, "-1,2")]
    public float centerX = 0.5f;

    [Export( PropertyHint.Range, "-1,2")]
    public float centerY = 0.5f;

    [Export( PropertyHint.Range, "0,0.5")]
    public float fade = 0.1f;

    protected override List<WipeCompositorEffect> _CreateEffects()
    {
      var wipe = new CircleWipeEffect
      {
        centerX = centerX,
        centerY = centerY,
        fade = fade
      };

      ApplyBaseWipeSettings( wipe );

      return [ wipe ];
    }

   
  }
}