using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class DirectionalWipe:BaseWipeEffect  
  { 
    [ExportGroup( "Directional" )]
    [Export( PropertyHint.Range, "0,360")]
    public float angle = 0.0f;

    [Export( PropertyHint.Range, "0,0.5")]
    public float fade = 0.1f;

    [Export( PropertyHint.Range, "0,0.5")]
    public DirectionalWipeEffect.DirectionType directionType = DirectionalWipeEffect.DirectionType.Single;

    protected override List<WipeCompositorEffect> _CreateEffects()
    {
      var wipe = new DirectionalWipeEffect
      {
        angle = angle,
        fade = fade,
        directionType = directionType
      };

      ApplyBaseWipeSettings( wipe );

      return [ wipe ];
    }

   
  }
}