using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class InOutWipe:WipeEffect  
  { 
    [Export]
    public WipeEffect wipeIn;

    [Export]
    public WipeEffect wipeOut;

    Compositor _compositor;

    public override List<WipeCompositorEffect> GetEffects( Compositor compositor )
    {
      if ( 
        _activeEffects != null && _activeEffects.Count > 0 && 
        compositor != null && compositor.CompositorEffects.Contains( _activeEffects[ 0 ] )
      )
      {
        return _activeEffects;
      }
      

      _compositor = compositor;
      _activeEffects = _CreateEffects();
      _compositor = null;
      

      return _activeEffects;
    }

    protected override List<WipeCompositorEffect> _CreateEffects()
    {
      var wipeInEffects  = wipeIn.GetEffects( _compositor );
      var wipeOutEffects = wipeOut.GetEffects( _compositor );

      // this.LogInfo( "EFFECTS: Num Ins:", wipeInEffects.Count, "Num Outs:", wipeOutEffects.Count );
      // this.LogInfo( "ACTIVE: Num Ins:", wipeIn.activeEffects.Count, "Num Outs:", wipeOut.activeEffects.Count );
      return Lists.FromLists( wipeInEffects, wipeOutEffects );
    }

    public override List<KeyFrameAnimation<float>> GetWipeAnimations( Wipe.Direction direction )
    {
      var list = new List<KeyFrameAnimation<float>>();

      var wipeInKeyFrames = new KeyFrameAnimation<float>();
      var wipeOutKeyFrames = new KeyFrameAnimation<float>();

      if ( Wipe.Direction.In == direction )
      {
        wipeInKeyFrames.Add( 0, 0 );
        wipeInKeyFrames.Add( 1, 1 );

        wipeOutKeyFrames.Add( 0, 0 );
        wipeOutKeyFrames.Add( 1, 0 );
      }
      else
      {        
        wipeOutKeyFrames.Add( 0, 1 );
        wipeOutKeyFrames.Add( 1, 0 );

        wipeInKeyFrames.Add( 0, 0 );
        wipeInKeyFrames.Add( 1, 0 );
      }
      
      var numIns = wipeIn.activeEffects.Count;
      var numOuts = wipeOut.activeEffects.Count;

      for ( int i = 0; i < numIns; i++ )
      {
        list.Add( wipeInKeyFrames );
      }

      for ( int i = 0; i < numOuts; i++ )
      { 
        list.Add( wipeOutKeyFrames );
      }
      
      this.LogInfo( "Num ins:", numIns, "Num outs:", numOuts );

      return list;
    }
  }
}