using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Text;
using Godot;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class NoiseWipe:BaseWipeEffect  
  { 
    [ExportGroup( "Noise" )]
    [Export( PropertyHint.Range, "0,1")]
    public float noiseAmount = 1.0f;

    [Export( PropertyHint.Range, "0.1,100")]
    public float noiseFrequency = 10f;

    [Export]
    public Vector2 noisePosition = Vector2.Zero;

    [Export]
    public Vector2 noiseWipeOffset = Vector2.Zero;

    protected override List<WipeCompositorEffect> _CreateEffects()
    {
      var wipe = new NoiseWipeEffect
      {
        noiseAmount = noiseAmount,
        noiseFrequency = noiseFrequency,
        noisePosition = noisePosition,
        noiseWipeOffset = noiseWipeOffset
      };

      ApplyBaseWipeSettings( wipe );

      return [ wipe ];
    }

   
  }
}