
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public enum AppPlatformOS
  {
    Windows,
    MacOS,    
    iOS,
    Android,
    MetaHorizonOS,
    Switch,
    Switch2,
    PS4,
    PS5,
    XBoxOne,
    XBoxSeriesXS
  }

  public enum AppLauncher
  {
    Native,
    Steam,
    Epic,
    Web
  }

  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/App.svg")]
  public partial class App: Node
  { 
    [Export]
    public AppPlatformOS os;

    [Export]
    public AppLauncher launcher;

    int _fps = 60;
    
    public int x = 0;
    
    [Export]
    public int fps 
    {
      get => _fps;
      set { _fps = value; Engine.MaxFps = _fps; }
    }

    
    
  }
}