using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public class AudioSample
  { 
    float[,] _channels;
    
    float _sampleRate;

    public float sampleRate => _sampleRate;

    public static AudioSample Create( float[,] channelData, float sampleRate = 44100 )
    {
      var sample = new AudioSample();
      sample._channels   = channelData;
      sample._sampleRate = sampleRate;
      
      return sample;
    }

    public static AudioSample Create( int channels, int numSamples, float sampleRate = 44100 )
    {
      var sample = new AudioSample();
      sample._channels   = new float[ channels, numSamples ];
      sample._sampleRate = sampleRate;
      
      return sample;
    }

    public float Get( int sample, int channel = 0 )
    {
      return _channels[ channel, sample ];
    }

    public float Left( int sample )
    {
      return _channels[ 0, sample ];
    }

    public float Right( int sample )
    {
      return _channels[ 1, sample ];
    }

    public float this[ int channel, int sample ]
    {
      get { return _channels[ channel, sample ]; }
      set { _channels[ channel, sample ] = value; }
    }
    
  }
}