using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public class Constant:AudioProcessor
  { 
    public readonly AudioStreamOutput output;
    protected float _constantValue;

    public Constant( AudioGraph ag, float value ): base( ag )
    {
      _constantValue = value;
      output = new AudioStreamOutput( this );
    }

    public void SetConstant( float value )
    {
      _constantValue = value;
    }

    
    protected override void _ProcessAudio()
    {
      for ( int i = 0; i < bufferSize; i++ )
      {
        output[ i ] = _constantValue;
      }
      
    }


  }

}