using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public class PhaseGenerator:AudioGeneratorMono
  { 
    public readonly AudioEventInput<float> pitch;
    protected iPhaseGenerator _generator;

    public PhaseGenerator( AudioGraph ag, iPhaseGenerator generator ): base( ag )
    {
      pitch = new AudioEventInput<float>( this );
      this._generator = generator;
    }

    float _phase = 0;
    float _increment = 0.01f;

    protected override void _ProcessAudio()
    {
      if ( pitch.numEvents > 0 )
      {
        var p = pitch.lastEvent;
        var frequency = MathAudio.PitchToFrequency( p );
        _increment = frequency / audioGraph.sampleRate;
      }

      for ( int i = 0; i < bufferSize; i++ )
      {      
        _phase = MathAudio.IncrementPhase( _phase, _increment );

        var value = _generator.Get( _phase );

        output[ i ] = value;
      }
    }


  }

}