using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public class SineGenerator:AudioGeneratorMono
  { 
    public readonly AudioStreamInput frequency;

    public SineGenerator( AudioGraph ag ): base( ag )
    {
      frequency = new AudioStreamInput( this );
    }

    float _phase = 0;

    protected override void _ProcessAudio()
    {
      for ( int i = 0; i < bufferSize; i++ )
      { 
        float increment = frequency[ i ] / audioGraph.sampleRate;
      
        _phase += increment;
        _phase = MathX.Repeat( _phase, 1 );

        output[ i ] = Mathf.Sin( _phase * Mathf.Pi* 2.0f );
      }

    }


  }

}