using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public class WaveTableGenerator:AudioGeneratorMono
  { 
    public readonly AudioStreamInput frequency;
    protected WaveTable waveTable;

    public WaveTableGenerator( AudioGraph ag, WaveTable waveTable ): base( ag )
    {
      frequency = new AudioStreamInput( this );
      this.waveTable = waveTable;
    }

    float _phase = 0;

    protected override void _ProcessAudio()
    {
      for ( int i = 0; i < bufferSize; i++ )
      {
        float increment = frequency[ i ] / audioGraph.sampleRate;
      
        _phase += increment;
        _phase = MathX.Repeat( _phase, 1 );

        var value = waveTable.Get( _phase );

        output[ i ] = waveTable.Get( _phase );
      }
    }


  }

}