using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public class AudioConnection : AudioNode
  { 
    protected AudioProcessor _audioProcessor;
    public AudioProcessor audioProcessor => _audioProcessor;
    protected bool _isInput = true;
    public bool isInput => _isInput; 
    

    public AudioConnection( AudioProcessor p, bool isInput ): base( p.audioGraph )
    {
      _audioProcessor = p;
      _isInput = isInput;
      p._Add( this );
    }

    public override void Destroy()
    {
      _audioGraph = null;
      _audioProcessor = null;
    }

    public virtual void PollDependencies()
    {
      
    }
  }

}