using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;
using System;

namespace Rokojori
{ 
  public class AudioEventInput<T> : AudioEvent<T>
  {
    public AudioEventInput( AudioProcessor p ):base( p, true )
    {}

    protected List<AudioEventOutput<T>> _outputs = new List<AudioEventOutput<T>>();

    public List<AudioEventOutput<T>> connected => _outputs;

    public void _GetConnectedFrom( AudioEventOutput<T> output )
    {
      _outputs.Add( output );
    }

    public void _GetDisconnectedFrom( AudioEventOutput<T> output )
    {
      _outputs.Remove( output );
    }   

    public int numEvents => _events.Count;

    public T this[ int index ]
    {
      get { return _events[ index ]; }
    }

    public T lastEvent => _events[ _events.Count -1 ];

    public override void PollDependencies()
    {
      _events.Clear();

      _outputs.ForEach(
        o =>
        {
          o.audioProcessor.Process();
        }
      );

      _outputs.ForEach(
        o => 
        {
          _events.AddRange( o.GetEventsList() );
        }
      );
    }

    
  }
}