using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public class AudioEventOutput<T> : AudioEvent<T>
  { 
    public AudioEventOutput( AudioProcessor p, bool autoClear = true ):base( p, autoClear )
    {}

    List<AudioEventInput<T>> _inputs = new List<AudioEventInput<T>>();

    public List<AudioEventInput<T>> connected => _inputs;

    public bool IsConnectedTo( AudioEventInput<T> input )
    {
      return _inputs.Contains( input );
    }

    public void ConnectTo( AudioEventInput<T> input )
    {
      _inputs.Add( input );
      input._GetConnectedFrom( this );
    }

    public void Disconnect( AudioEventInput<T> input )
    {
      _inputs.Remove( input );
      input._GetDisconnectedFrom( this );
    }

    public void Push( T t )
    {
      _events.Add( t );
    }

    public List<T> GetEventsList()
    {
      return _events;
    }

  }

}