using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public class AudioNode
  { 
    protected AudioGraph _audioGraph;
    
    public AudioGraph audioGraph => _audioGraph;
       
    public virtual void Destroy()
    {
      _audioGraph = null;
    }

    public virtual void Clear()
    {

    }

    public virtual void UpdateBuffserSize()
    {

    }

    public virtual int bufferSize => audioGraph.bufferSize;

    public AudioNode( AudioGraph ag)
    {
      _audioGraph = ag;

      if ( ag != null )
      {
        ag._Add( this );
      }
      
    }

    
  }
}