using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public class AudioProcessor:AudioNode
  { 
    protected int _processedID = -1;
    protected List<AudioConnection> _connections = new List<AudioConnection>();
    protected List<AudioConnection> _inputConnections = new List<AudioConnection>();
    protected List<AudioConnection> _outputConnections = new List<AudioConnection>();

    public AudioProcessor( AudioGraph ag ):base( ag )
    {}

    public void _Add( AudioConnection ac )
    {
      _connections.Add( ac );

      if ( ac.isInput )
      {
        _inputConnections.Add( ac  );
      }
      else
      {
        _outputConnections.Add( ac );
      }
    }

    public void Process()
    {
      if ( processed )
      {
        return;
      }

      SetProcessed();

      for ( int i = 0; i < _inputConnections.Count; i++ )
      {
        _inputConnections[ i ].PollDependencies(); 
      }

      _ProcessAudio();
          
    }


    protected virtual void _ProcessAudio()
    {

    }

    public virtual bool processed
    {
      get 
      {         
        return _processedID == _audioGraph.frameIndex; 
      }
    }

    public virtual void SetProcessed()
    {
      _processedID = _audioGraph.frameIndex;
    }
  }
}