using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;
using System;

namespace Rokojori
{ 
  public class AudioStreamInput : AudioStream
  { 
    public AudioStreamInput( AudioProcessor p ):base( p, true )
    {}

    protected List<AudioStreamOutput> _outputs = new List<AudioStreamOutput>();

    public List<AudioStreamOutput> connected => _outputs;

    public void _GetConnectedFrom( AudioStreamOutput output )
    {
      _outputs.Add( output );
    }

    public void _GetDisconnectedFrom( AudioStreamOutput output )
    {
      _outputs.Remove( output );
    }    
    
    public override void PollDependencies()
    {
      _outputs.ForEach(
        o =>
        {
          o.audioProcessor.Process();
        }
      );

      _outputs.ForEach(
        o =>
        {
          var buffer = o.GetOutputStreamBuffer();

          for ( int i = 0; i < bufferSize; i++ )
          {
            _buffer[ i ] += buffer[ i ];
          }    
        }
      );

    }

    public float this[ int index ]
    {
      get { return _buffer[ index ]; }
    }
   
  }
  

}