using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public class AudioStreamOutput : AudioStream
  { 
    public AudioStreamOutput( AudioProcessor p, bool autoClear = true ):base( p, autoClear )
    {}

    List<AudioStreamInput> _inputs = new List<AudioStreamInput>();

    public List<AudioStreamInput> connected => _inputs;

    public bool IsConnectedTo( AudioStreamInput input )
    {
      return _inputs.Contains( input );
    }

    public void ConnectTo( AudioStreamInput input )
    {
      _inputs.Add( input );
      input._GetConnectedFrom( this );
    }

    public void Disconnect( AudioStreamInput input )
    {
      _inputs.Remove( input );
      input._GetDisconnectedFrom( this );
    }

    public float this[ int index ]
    {
      set{ _buffer[ index ] = value;}
    }

    public float[] GetOutputStreamBuffer()
    {
      return _buffer;
    }

   
    

  }

}