using Godot;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{  
  [GlobalClass,Tool, Icon("res://addons/rokojori_action_library/Icons/AudioManager.svg") ]
  public partial class AudioManager:Node
  {
    [Export]
    public AudioManagerData data = new AudioManagerData();
    
    Dictionary<AudioFlag,float> _lastPlayTime = new Dictionary<AudioFlag, float>();

    public float GetLastPlayed( AudioFlag selectorFlag )
    {
      if ( ! _lastPlayTime.ContainsKey( selectorFlag ) )
      {
        return -1;
      }

      return _lastPlayTime[ selectorFlag ];
    }

    public void RecordSoundPlaying( AudioFlag selectorFlag )
    {
      _lastPlayTime[ selectorFlag ] = TimeLine.osTime;
    }

    public bool CanPlay( AudioFlag selectorFlag, float blockDuration )
    {
      if ( ! _lastPlayTime.ContainsKey( selectorFlag ) )
      {
        return true;
      }

      return ( TimeLine.osTime - _lastPlayTime[ selectorFlag ] ) > blockDuration;

    }
  }
}