using Godot;


namespace Rokojori
{  
  public class BitMath
  {
    public static int GetInt32BitMask( int bit )
    {
      return ( 1 << bit );
    }

    public static long GetInt64BitMask( int bit )
    {
      return ( 1 << bit );
    }

    public static int SetBit( int value, int bitPosition )
    {
      return value | GetInt32BitMask( bitPosition );
    }

    public static long SetBit( long value, int bitPosition )
    {
      return value | GetInt64BitMask( bitPosition );
    }

    public static int UnsetBit( int value, int bitPosition )
    {
      return value & ~GetInt32BitMask( bitPosition );
    }

    public static long UnsetBit( long value, int bitPosition )
    {
      return value & ~GetInt64BitMask( bitPosition );
    }

    public static bool IsBitSet( int value, int bitPosition )
    {
      var mask = GetInt32BitMask( bitPosition );
      return ( value & mask ) == mask;
    }

    public static bool IsBitSet( long value, int bitPosition )
    {
      var mask = GetInt64BitMask( bitPosition );
      return ( value & mask ) == mask;
    }

    public static bool IsMaskSet( int value, int mask )
    {
      return ( value & mask ) == mask;
    }

    public static bool IsMaskSet( long value, long mask )
    {
      return ( value & mask ) == mask;
    }
    
  }
}