using Godot;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{  
  public partial class BitView
  {
    public void WriteByte( byte value )
    {
      for ( int i = 0; i < 8; i++ )
      {
        WriteBit( BitMath.IsBitSet( value, i ) );
      }
    }

    public void WriteBytes( byte[] values )
    {
      for ( int i = 0; i < values.Length; i++ )
      {
        WriteByte( values[ i ] );
      }
    }

    public byte ReadByte()
    {
      var byteValue = 0;

      for ( int i = 0; i < 8; i++ )
      {
        var bitValue = ReadBit();
        
        if ( ! bitValue )
        {
          continue;
        }

        byteValue = byteValue | ( 1 << i );
      }

      return (byte) byteValue;
    }

    public void ReadBytes( byte[] output, int size )
    {
      for ( int i = 0; i < size; i++ )
      {
        output[ i ] = ReadByte();
      }
    }

    public byte[] ReadByteArray( int size )
    {
      var data = new byte[ size ];
      ReadBytes( data, size );
      return data;
    }

  }
}