using Godot;
using System.Collections.Generic;
using System.Text;
using System;

namespace Rokojori
{  
  public partial class BitView
  {
    public void WriteVector2( Vector2 value )
    {
      WriteFloat( value.X );
      WriteFloat( value.Y );
    }

    public Vector2 ReadVector2()
    {
      return new Vector2( ReadFloat(), ReadFloat() );
    }

    public void WriteVector3( Vector3 value )
    {
      WriteFloat( value.X );
      WriteFloat( value.Y );
      WriteFloat( value.Z );
    }

    public Vector3 ReadVector3()
    {
      return new Vector3( ReadFloat(), ReadFloat(), ReadFloat() );
    }
    
    public void WriteVector4( Vector4 value )
    {
      WriteFloat( value.X );
      WriteFloat( value.Y );
      WriteFloat( value.Z );
      WriteFloat( value.W );
    }

    public Vector4 ReadVector4()
    {
      return new Vector4( ReadFloat(), ReadFloat(), ReadFloat(), ReadFloat() );
    }

    public void WriteQuaternion( Quaternion value )
    {
      WriteFloat( value.X );
      WriteFloat( value.Y );
      WriteFloat( value.Z );
      WriteFloat( value.W );
    }

    public Quaternion ReadQuaternion()
    {
      return new Quaternion( ReadFloat(), ReadFloat(), ReadFloat(), ReadFloat() );
    }
  }
}