using Godot;

using System;
using System.Text;

namespace Rokojori
{  
  public class ByteView
  {
    byte[] _data = new byte[ 0 ];
    int _start;
    int _size;
    
    public ByteView From( byte[] bytes )
    {
      var view = new ByteView();
      view._start = 0;
      view._size = bytes.Length;
      view._data = bytes;

      return view;
    }

    public byte[] GetBytes()
    {
      if ( _start == 0 && _size == _data.Length )
      {
        return _data;
      }

      var bytes = new byte[ _size ];

      Array.Copy( _data, _start, bytes, 0, _size );

      return bytes; 
    }

    public string Stringify()
    {
      return Stringify( _data, _start, _size );
    }

    public static string Stringify( byte[] _data, int _start = 0, int _size = -1)
    {
      if ( _size < 0 )
      {
        _size = _data.Length - _start;
      }

      var sb = new StringBuilder();

      for ( int i = 0; i < _size; i++ )
      {
        if ( i != 0 )
        {
          sb.Append( " " ); 
        }

        var value = _data[ i + _start ] + "";

        while ( value.Length < 3 )
        {
          value = "0" + value;
        }

        sb.Append( value );
        
      }

      return sb.ToString();
    }

  
    
  } 
}