using Godot;

using System;
using System.Collections.Generic;


namespace Rokojori
{  
  public class Bytes
  {    
    public static string ConvertToString( ulong numBytes, int basis = 1000 )
    {
      var unitIndex = 0;
      var units = new List<string>()
      {
        "Bytes",
        "KB",
        "MB",
        "GB",
        "TB"
      };



      double num = numBytes;  

      while ( num >= 1000 && unitIndex < ( units.Count - 1 ) )
      {
        num = num / 1000.0;
        unitIndex ++;
      }

      var fNum = (float) num;
      return RegexUtility._FFF( fNum ) + " " + units[ unitIndex ];
    }

    public static byte SetBit( byte value, int position )
    {      
      return (byte) ( ( 1 << position ) | value );
    }

    public static byte UnsetBit( byte value, int position )
    {
      var mask = 1 << position;
      var invertedMask = ~mask;      

      return (byte)( value & invertedMask ); 
    } 

    public static bool IsBitSet( byte value, int position )
    {      
      var mask = 1 << position;
      return ( mask & value ) == mask ;
    }

    public static List<byte> Convert( List<float> floats )
    {
      var list = new List<byte>();
      floats.ForEach( f => list.AddRange( BitConverter.GetBytes( f ) ) ); 
      return list;
    }

    public static List<byte> Convert( List<int> ints )
    {
      var list = new List<byte>();
      ints.ForEach( i => list.AddRange( BitConverter.GetBytes( i ) ) ); 
      return list;
    }

    public static List<byte> Convert( List<Vector4> v )
    {
      var list = new List<byte>();
      v.ForEach( 
        f => 
        {
          list.AddRange( BitConverter.GetBytes( f.X ) );
          list.AddRange( BitConverter.GetBytes( f.Y ) );
          list.AddRange( BitConverter.GetBytes( f.Z ) );
          list.AddRange( BitConverter.GetBytes( f.W ) );
        }
      ); 
      return list;
    }
  }
}