
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class SetActiveCamera:CameraSlotSelector
  {
    [Export]
    public VirtualCamera virtualCamera;

    [ExportToolButton( "Set Reference Name" )]
    public Callable setReferencedNameButton => Callable.From(
      ()=>
      { 
        if ( virtualCamera == null )
        {
          this.Name = "Set Active Camera (nothing)";
        }
        else
        {
          this.Name = "Set Active Camera " + virtualCamera.Name;
        }
      }
    );

    [ExportGroup( "Create Slot")]
    [Export]
    public bool createSlotIfNotPresent = true;

    [Export]
    public SelectorFlag[] slotFlags;

    public override CameraSlot GetCameraSlot()
    {
      var vm = CameraManager.Get();
      var slot = vm.GetSlot( virtualCamera );

      if ( slot == null )
      {
        slot = vm.CreateChild<CameraSlot>();
        slot.camera = virtualCamera;
        slot.flags = slotFlags;
        
        vm.RefreshSlots( true );
      }

      return slot;
    }

  }
}