
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class CameraTargetOffset:Node3D
  { 
    [Export]
    public float cameraTargetMinOffsetZ = 0;

    [Export]
    public float cameraTargetMaxOffsetZ = 10;

    [Export]
    public Smoothing cameraTargetOffsetZSmoothing = new FrameSmoothing();
    

    [Export]
    public float cameraTargetMinOffsetY = 1.7f;

    [Export]
    public float cameraTargetMaxOffsetY = 2f;

    [Export]
    public Smoothing cameraTargetOffsetYSmoothing = new FrameSmoothing();

    protected float nextZ = 0;
    protected float nextY = 0;

    public virtual void SetMovingForward( float movingForward )
    {
      nextZ = Mathf.Lerp( cameraTargetMinOffsetZ, cameraTargetMaxOffsetZ, movingForward );
      nextY = Mathf.Lerp( cameraTargetMinOffsetY, cameraTargetMaxOffsetY, movingForward );
    }

    public override void _Process( double delta )
    {
      var smoothedOffsetZ = cameraTargetOffsetZSmoothing.Smooth( nextZ, (float)delta );      
      this.SetLocalZ( smoothedOffsetZ );

      
      var smoothedOffsetY = cameraTargetOffsetYSmoothing.Smooth( nextY, (float)delta );      
      this.SetLocalY( smoothedOffsetY );
    }
  }
}