
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/LookAtCamera.svg") ]
  public partial class LookAtCamera:VirtualCamera
  {
    [Export]
    public Node3D target;

    [Export]
    public Smoothing smoothing;

    [Export]
    public TimeLine timeLine;

    [ExportToolButton( "Copy Camera Pose With Target")]
    public Callable copyCameraPoseWithTargetButton => Callable.From(
      ()=>
      {
        #if TOOLS

        var camera = EditorInterface.Singleton.GetEditorViewport3D().GetCamera3D();
        target.GlobalPosition = camera.GlobalPosition + camera.GlobalForward() * 25;
        Pose.CopyTo( camera, this );
        
        #endif
      }
    );

    public override void _Process( double delta )
    {
      if ( Engine.IsEditorHint() )
      {
        return;
      }

      var lookAtPosition = smoothing.Smooth( target.GlobalPosition, timeLine.delta );

      if ( ! Math3D.IsValid( lookAtPosition ) )
      {
        lookAtPosition = target.GlobalPosition;
        smoothing.SetCurrent( target.GlobalPosition );
      }

      // this.LogInfo( target.GlobalPosition, lookAtPosition, timeLine.delta );
      this.LookAt( lookAtPosition, Vector3.Up, true );
    }

  }
}