
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorGroup.svg")]
  public partial class ThirdPersonCameraData: Resource
  {
    [Export]
    public SensorDeviceSelector deviceSelector;

    [ExportGroup("Yaw")]
    
    [Export]
    public float yawSpeed = 1.0f;

    [Export]
    public Sensor yawPositiveAxis;

    [Export]
    public Sensor yawNegativeAxis;

    [Export]
    public float yawDeadZone = 0.1f;


    [Export]
    public float yawPower = 1.5f;



    [ExportGroup("Pitch")]

    [Export]
    public float relativePitchSpeed = 1.0f;

    [Export]
    public Sensor pitchPositiveAxis;

    [Export]
    public Sensor pitchNegativeAxis;

    [Export]
    public float pitchDeadZone = 0.1f;

     [Export]
    public float pitchPower = 1.5f;

    [Export]
    public bool pitchIsRelative = true;
    
   
  }
}