
using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/SensorGroup.svg")]
  public partial class ThirdPersonCameraSettings: Resource
  {
    [Export]
    public Smoothing targetFollowSmoothing = new FrameSmoothing();

    [Export]
    public Vector3 offset = Vector3.Zero;

    [Export]
    public Smoothing yawSmoothing = new FrameSmoothing();

    [Export]
    public Smoothing pitchSmoothing = new FrameSmoothing();

    [Export]
    public ThirdPersonCameraData[] deviceData = [];   

    [ExportGroup("Yaw")]
    [Export]
    public float yawSpeed = 1;

    [ExportGroup("Pitch")]
    [Export]
    public float relativePitchSpeed = 1;

    [Export]
    public float minPitch = -10;

    [Export]
    public float maxPitch = 80;


    [ExportGroup("Distance")]
    [Export]
    public Curve distanceForPitch = MathX.Curve( 1, 1 );

    [Export]
    public float distanceScale = 1;


    public float GetNormalizedPitch( float pitch )
    {
      return MathX.Normalize( pitch, minPitch, maxPitch );
    }

    public ThirdPersonCameraData GetActiveDeviceData()
    {
      var sm = Unique<SensorManager>.Get();

      var lastActive = sm.lastActiveDevice;

      var lastActiveData = deviceData.FindNonNull( d => d.deviceSelector.Selects( lastActive ) ); 

      return lastActiveData != null ? lastActiveData : deviceData[ 0 ];
    }
  }
}