
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class ThirdPersonCameraTargetOffset:CameraTargetOffset
  { 

    [Export]
    public ThirdPersonCamera thirdPersonCamera;

    [Export]
    public Curve pitchMultiply;


    public override void SetMovingForward( float movingForward )
    {
      if ( pitchMultiply != null && thirdPersonCamera != null )
      {
        var normalizedPitch = thirdPersonCamera.settings.GetNormalizedPitch( thirdPersonCamera.pitch );
        var sampledPitchMultiply = pitchMultiply.Sample( normalizedPitch );
        movingForward *= sampledPitchMultiply;
      }
      
      

      nextZ = Mathf.Lerp( cameraTargetMinOffsetZ, cameraTargetMaxOffsetZ, movingForward );
      nextY = Mathf.Lerp( cameraTargetMinOffsetY, cameraTargetMaxOffsetY, movingForward );
    }
    
  }
}