
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class ScreenShake:Action
  { 
    [Export]
    public ScreenShakeSettings settings;

    [Export]
    public bool useActiveCameraSlot = false;    

    [ExportGroup("Other Camera Slot")]
    [Export]
    public CameraSlot cameraSlot;

    [Export]
    public VirtualCamera camera;

    [Export]
    public int cameraSlotIndex = -1;

    [Export]
    public Selector cameraSlotSelector;

    
    protected override void _OnTrigger()
    {
      var manager = CameraManager.Get();
      var resolvedSlot = useActiveCameraSlot ? manager.activeSlot : cameraSlot;

      if ( resolvedSlot == null && camera != null )
      {
        resolvedSlot = manager.GetSlot( camera );
      }

      if ( resolvedSlot == null )
      {  
        if ( cameraSlotIndex != -1 )
        {
          resolvedSlot = manager.GetSlot( cameraSlotIndex );
        }
        else if ( cameraSlotSelector != null )
        {
          resolvedSlot = Selectors.GetFromDirectChildren<CameraSlot>( manager, cameraSlotSelector );
        }        
      }

      if ( resolvedSlot == null )
      {
        this.LogError( "No camera slot found" );

        return;
      }

      // this.LogInfo( "Camera slot found" );
      var cameraEffect = new CameraEffect();

      cameraEffect.timeline = TimeLineManager.Ensure( settings.duration.timeLine );
      resolvedSlot.SetCameraEffect( cameraEffect );
    }

    
  }
}