
using Godot;
using System.Collections.Generic;
using System;
namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class CenterAndRangeDepthOfFieldEffect:_XX_DepthOfFieldEffect
  {

    [Export( PropertyHint.Range, "0,1000")]
    public float centerDistance = 10;

    [Export( PropertyHint.Range, "0,50")]
    public float centerDistanceDetails = 0;

    [Export( PropertyHint.Range, "0,1")]
    public float centerDistanceMicro = 0;

    [Export( PropertyHint.Range, "0,1000")]
    public float absoluteRange = 1;

    [Export( PropertyHint.Range, "0,0.5")]
    public float distanceRelativeRange = 0.1f;


    [Export( PropertyHint.Range, "0,100")]
    public float absoluteTransition = 1;

    [Export( PropertyHint.Range, "0,1")]
    public float distanceRelativeTransition = 0.1f;

    [Export( PropertyHint.Range, "0.1,10")]
    public float nearTransitionScale = 0.5f;

    [Export( PropertyHint.Range, "0.1,10")]
    public float farTransitionScale = 2.5f;

    [Export]
    public NormalizedValue amount;

    [Export]
    public Float8Value exposure;

    public override BoxedFloatValue[] GetFloatValues()
    {
      var distance = MathX.Max( 0, centerDistance + centerDistanceDetails + centerDistanceMicro );
      var range = absoluteRange + distance * distanceRelativeRange;
      var far = distance + range;
      var near = distance - range;

      var farTransition  = ( absoluteTransition + ( distanceRelativeTransition * far ) ) * farTransitionScale;
      var nearTransition = ( absoluteTransition + ( distanceRelativeTransition * near ) )* nearTransitionScale;

      _values[ 0 ] = BoolFloatValue.Create( 1 );
      _values[ 1 ] = FloatValue.Create( far );
      _values[ 2 ] = FloatValue.Create( farTransition );

      _values[ 3 ] = BoolFloatValue.Create( 1 );
      _values[ 4 ] = FloatValue.Create( near );
      _values[ 5 ] = FloatValue.Create( nearTransition );

      _values[ 6 ] = amount;
      _values[ 7 ] = exposure;

      return _values;
    }
  }

}