
using Godot;
using System.Collections.Generic;
using System;
namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class FogEffect:PostProcessVolumeEffect
  {
    [Export]
    public ColorValue lightColor;

    [Export]
    public Float16Value lightEnergy;

    [Export]
    public NormalizedValue sunScatter; 

    [Export]
    public PowerValue density; 

    [Export]
    public NormalizedValue aerialPerspective; 

    [Export]
    public NormalizedValue skyEffect;

    [Export]
    public Polar1024Value height;

    [Export]
    public Polar16Value heightDensity;

    BoxedFloatValue[] _values = new BoxedFloatValue[ 7 ];


    public override BoxedFloatValue[] GetFloatValues()
    {
      _values[ 0 ] = lightEnergy;
      _values[ 1 ] = sunScatter;
      _values[ 2 ] = density;
      _values[ 3 ] = aerialPerspective;
      _values[ 4 ] = skyEffect;
      _values[ 5 ] = height;
      _values[ 6 ] = heightDensity;

      return _values;
    }

    public override void SetFloatValues( BoxedFloatValue[] values )
    {
      lightEnergy = Float16Value.Create( _values[ 0 ] );
      sunScatter = NormalizedValue.Create( _values[ 1 ] );
      density = PowerValue.Create( _values[ 2 ] );
      aerialPerspective = NormalizedValue.Create( _values[ 3 ] );
      skyEffect = NormalizedValue.Create( _values[ 4 ] );
      height = Polar1024Value.Create( _values[ 5 ] );
      heightDensity = Polar16Value.Create( _values[ 6 ] );
    }

    ColorValue[] _colors = new ColorValue[ 1 ];


    public override ColorValue[] GetColorValues()
    {
      _colors[ 0 ] = lightColor;

      return _colors;
    }

    public override void SetColorValues( ColorValue[] values )
    {
      lightColor = ColorValue.Create( values[ 0 ] );
    }

    public override void Lerp( object fogEffects, List<PostProcessVolume> volumes )
    {
      LerpFrom( (List<FogEffect>) fogEffects, volumes );
    }

    public void LerpFrom( List<FogEffect> fogEffects, List<PostProcessVolume> volumes )
    {     
      LerpColors( fogEffects, volumes );
      LerpFloats( fogEffects, volumes );
    }

    public override void Apply( WorldEnvironment worldEnvironment )
    {
      if ( worldEnvironment == null || worldEnvironment.Environment == null )
      {
        return;
      }
      
      if ( lightColor != null )
      {
        worldEnvironment.Environment.FogLightColor = lightColor.value;
      }

      /*
      
      _values[ 0 ] = lightEnergy;
      _values[ 1 ] = sunScatter;
      _values[ 2 ] = density;
      _values[ 3 ] = aerialPerspective;
      _values[ 4 ] = skyEffect;
      _values[ 5 ] = height;
      _values[ 6 ] = heightDensity;

      */

      if ( lightEnergy != null )
      {
        worldEnvironment.Environment.FogLightEnergy = lightEnergy.value;
      }
      
      if ( sunScatter != null )
      {
        worldEnvironment.Environment.FogSunScatter = sunScatter.value;
      }

      if ( density != null )
      {
        worldEnvironment.Environment.FogDensity = density.value;
      }

      if ( aerialPerspective != null )
      {
        worldEnvironment.Environment.FogAerialPerspective = aerialPerspective.value;
      }

      if ( skyEffect != null )
      {
        worldEnvironment.Environment.FogSkyAffect = skyEffect.value;
      }

      if ( height != null )
      {
        worldEnvironment.Environment.FogHeight = height.value;
      }

      if ( heightDensity != null )
      {
        worldEnvironment.Environment.FogHeightDensity = heightDensity.value;
      }
    }
  }
}