
using Godot;
using System.Collections.Generic;
using System;
namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class GlowEffectLevels:Resource
  {
    [Export(PropertyHint.Range,"0,10")]
    public float level1 = 1f;
    [Export(PropertyHint.Range,"0,10")]
    public float level2 = 1f;
    [Export(PropertyHint.Range,"0,10")]
    public float level3 = 1f;
    [Export(PropertyHint.Range,"0,10")]

    public float level4 = 1f;
    [Export(PropertyHint.Range,"0,10")]
    public float level5 = 1f;
    [Export(PropertyHint.Range,"0,10")]
    public float level6 = 1f;
    [Export(PropertyHint.Range,"0,10")]
    public float level7 = 1f;

    [Export]
    public bool normalized = true;

    public float sum => level1 + level2 + level3 + level4 + level5 + level6 + level7;
    public float normalizer => normalized ? 1f / sum : 1f;

    public void LerpFrom( List<GlowEffect> glowEffects, List<PostProcessVolume> volumes )
    {
      level1 = 0;
      level2 = 0;
      level3 = 0;
      level4 = 0;
      level5 = 0;
      level6 = 0;
      level7 = 0;

      float weight = 0;

      for ( int i = 0; i < glowEffects.Count; i++ )
      {
        var levels = glowEffects[ i ].levels;

        if ( levels == null )
        {
          continue;
        }

        var normalizer = levels.normalizer;

        level1 += levels.level1 * normalizer;
        level2 += levels.level2 * normalizer;
        level3 += levels.level3 * normalizer;
        level4 += levels.level4 * normalizer;
        level5 += levels.level5 * normalizer;
        level6 += levels.level6 * normalizer;
        level7 += levels.level7 * normalizer;

        weight += volumes[ i ].combinedWeight;
      }

      if ( weight == 0 )
      {
        return;
      }

      level1 /= weight;
      level2 /= weight;
      level3 /= weight;
      level4 /= weight;
      level5 /= weight;
      level6 /= weight;
      level7 /= weight;

    }

  }
}