
using Godot;
using System.Collections.Generic;
using System;
using System.Linq;
namespace Rokojori
{  
  public interface IPostProcessEffectProcessor
  {
    public void ClearForStackUpdate();
    public void OnVolumeUpdate( PostProcessVolume volume, List<PostProcessVolumeEffect> allEffects );
    public void Apply( WorldEnvironment worldEnvironment );
  }

  public class PostProcessEffectProcessor<T>:IPostProcessEffectProcessor where T:PostProcessVolumeEffect, new()
  {
    public T combinedEffect = new T();
    public List<T> activeEffects = [];
    public List<PostProcessVolume> activeVolumes = [];

    public void ClearForStackUpdate()
    {
      activeEffects.Clear();
      activeVolumes.Clear();
    }

    public void OnVolumeUpdate( PostProcessVolume volume, List<PostProcessVolumeEffect> allEffects )
    {
      var glows = GetEffectType<T>( allEffects );
      activeEffects.AddRange( glows );

      glows.ForEach( g => activeVolumes.Add( volume ) );
    }

    List<T> GetEffectType<T>( List<PostProcessVolumeEffect> effects ) where T:PostProcessVolumeEffect
    {
      return effects.FilterType<PostProcessVolumeEffect,T>();
    }

    public void Apply( WorldEnvironment worldEnvironment )
    {
      combinedEffect.Lerp( activeEffects, activeVolumes );
      combinedEffect.Apply( worldEnvironment );
    }
  } 
}