
using Godot;
using System.Collections.Generic;
using System;
using System.Linq;
namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/PostProcess.svg") ]
  public partial class PostProcessVolume: Node3D
  {
    [Export]
    public bool enabled = true;
    
    [Export]
    public float weight;

    public float combinedWeight => ! enabled ? 0 : weight;

    [Export]
    public int priority = 0;

    [Export]
    public PostProcessVolumeEffect[] effects;
    
    [ExportToolButton("Add To Camera Manager")]
    public Callable AddButton => Callable.From( 
      ( ) =>
      {
        var volumes = CameraManager.Get().postProcessVolumes;

        if ( volumes.Contains( this ) )
        {
          return;
        }

        CameraManager.Get().postProcessVolumes = Arrays.Add( volumes, this );
      }
    );

    public void UpdateEffects( CameraManager manager )
    {
      effects.ForEach(
        ( e )=>
        {
          if ( e is FollowDepthOfFieldEffect fd )
          {
            var node = GetNode( fd.node );

            var d = 0f;

            if ( node != null && node is Node3D n3 )
            {
              var camera = manager.camera;

              #if TOOLS 

              if ( Engine.IsEditorHint() )
              {
                camera = EditorInterface.Singleton.GetEditorViewport3D().GetCamera3D();
              }

              #endif

              d = camera.DistanceTo( n3 );
            }

            fd.SetCenterDistance( d );
          }
        }
      );
    }

  }
}