
using Godot;
using System.Collections.Generic;
using System;
namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class _XX_DepthOfFieldEffect:PostProcessVolumeEffect
  {

    protected BoxedFloatValue[] _values = new BoxedFloatValue[ 8 ];


    public override BoxedFloatValue[] GetFloatValues()
    {
      return _values;
    }

    public override void SetFloatValues( BoxedFloatValue[] values )
    {
      _values = values;
    }  

    public override void Lerp( object depthOfFieldEffects, List<PostProcessVolume> volumes )
    {
      LerpFrom( (List<_XX_DepthOfFieldEffect>) depthOfFieldEffects, volumes );
    }

    public void LerpFrom( List<_XX_DepthOfFieldEffect> depthOfFieldEffects, List<PostProcessVolume> volumes )
    {     
      LerpFloats( depthOfFieldEffects, volumes );
    }

    public override void Apply( WorldEnvironment worldEnvironment )
    {
      if ( worldEnvironment == null || 
           worldEnvironment.CameraAttributes == null ||
           ! ( worldEnvironment.CameraAttributes is CameraAttributesPractical )
      )
      {
        return;
      }

      var cap = (CameraAttributesPractical) worldEnvironment.CameraAttributes;

      var floatValues = GetFloatValues();

      if ( floatValues[ 0 ] != null )
      {
        cap.DofBlurFarEnabled = floatValues[ 0 ].GetFloatValue() > 0.5f;
      }

      if ( floatValues[ 1 ] != null )
      {
        cap.DofBlurFarDistance = floatValues[ 1 ].GetFloatValue();
      }

      if ( floatValues[ 2 ] != null )
      {
        cap.DofBlurFarTransition = floatValues[ 2 ].GetFloatValue();
      }

      if ( floatValues[ 3 ] != null )
      {
        cap.DofBlurNearEnabled = floatValues[ 3 ].GetFloatValue() > 0.5f;
      }

      if ( floatValues[ 4 ] != null )
      {
        cap.DofBlurNearDistance = floatValues[ 4 ].GetFloatValue();
      }

      if ( floatValues[ 5 ] != null )
      {
        cap.DofBlurNearTransition = floatValues[ 5 ].GetFloatValue();
      }

      if ( floatValues[ 6 ] != null )
      {
        cap.DofBlurAmount = floatValues[ 6 ].GetFloatValue();
      }

      if ( floatValues[ 7 ] != null )
      {
        cap.ExposureMultiplier = floatValues[ 7 ].GetFloatValue();
      }
    }
  }
}