
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class SetCameraFarDOF:Action
  { 
    [Export]
    public WorldEnvironment worldEnvironment;

    [Export]
    public bool dofBlurFarEnabled = true;

    protected override void _OnTrigger()
    {
      var atts = worldEnvironment.CameraAttributes as CameraAttributesPractical;

      if ( atts == null )
      {
        return;
      }

      atts.DofBlurFarEnabled = dofBlurFarEnabled;

    }
  }
}