
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/VirtualCamera3D.svg") ]
  public partial class VirtualCamera:Node3D
  {
    [Export] 
    public float fov = 60;

    [Export]
    public bool inputEnabled = true;

    [ExportToolButton( "Copy Camera Pose")]
    public Callable copyCameraPoseButton => Callable.From(
      ()=>
      {
        #if TOOLS

        var camera = EditorInterface.Singleton.GetEditorViewport3D().GetCamera3D();
        Pose.CopyTo( camera, this );
        
        #endif
      }
    );

    public Vector3 GetCameraPosition()
    {
      return GlobalPosition;
    }

    public Quaternion GetCameraRotation()
    {
      return GlobalBasis.GetRotationQuaternion();
    }

    public float GetCameraFOV()
    {
      return fov;
    }

  }
}