using Godot;

namespace Rokojori
{
  public enum ColorBlendModeType
  {
    Alpha,
    Add,
    Multiply,
    Replace
  }

  public class ColorBlendMode
  {
    public static Color Blend( ColorBlendModeType type, Color bottom, Color top )
    {
      switch ( type )
      {
        case ColorBlendModeType.Alpha:    return Alpha( bottom, top );
        case ColorBlendModeType.Multiply: return Multiply( bottom, top );
        case ColorBlendModeType.Add:      return Add( bottom, top );
        case ColorBlendModeType.Replace:  return Replace( bottom, top );
      }

      return new Color( 1, 1, 1, 1 ); 
    }

    public static Color Alpha( Color bottom, Color top )
    {
      var a = top.A + bottom.A * ( 1f - top.A );

      var colorBottom = ColorX.RGB( bottom );
      var colorTop    = ColorX.RGB( top );

      var colorRGB = ( colorTop * top.A +  colorBottom * bottom.A * ( 1f - top.A ) ) / a;

      return ColorX.Create( colorRGB, a ); 
    }

    public static Color Multiply( Color bottom, Color top )
    {
      return bottom * top;
    }

    public static Color Add( Color bottom, Color top )
    {
      return bottom + top;
    }

    public static Color Replace( Color bottom, Color top )
    {
      return top;
    }

  }
}