using Godot;
using System.Collections.Generic;

namespace Rokojori
{
  public enum ColorChannelType
  {
    Red,
    Green,
    Blue,
    Hue,
    Saturation,
    Luminance,
    Alpha
  }

  public static class ColorChannelTypeUtility
  {
    public static bool NeedsIncludesForGLSLMember( ColorChannelType colorChannelType )
    {
      if ( ColorChannelType.Red == colorChannelType )
      {
        return false;
      }

      if ( ColorChannelType.Green == colorChannelType )
      {
        return false;
      }

      if ( ColorChannelType.Blue == colorChannelType )
      {
        return false;
      }

      if ( ColorChannelType.Alpha == colorChannelType )
      {
        return false;
      }

      return true;
    }

    public static string ToGLSLMember( string source, ColorChannelType colorChannelType )
    {
      if ( ColorChannelType.Red == colorChannelType )
      {
        return $"{source}.r";
      }

      if ( ColorChannelType.Green == colorChannelType )
      {
        return $"{source}.g";
      }

      if ( ColorChannelType.Blue == colorChannelType )
      {
        return $"{source}.b";
      }

      if ( ColorChannelType.Alpha == colorChannelType )
      {
        return $"{source}.a";
      }


      if ( ColorChannelType.Hue == colorChannelType )
      {
        return $"RGBtoHSL( {source} ).x";
      }

      if ( ColorChannelType.Saturation == colorChannelType )
      {
        return $"RGBtoHSL( {source} ).y";
      }

      if ( ColorChannelType.Luminance == colorChannelType )
      {
        return $"RGBtoHSL( {source} ).u";
      }

      return null;
    }
  }
}
